/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.espbase.query;

import com.sap.engine.services.webservices.espbase.query.exceptions.TechnicalException;
import com.sap.engine.services.webservices.wsdl.WSDLDOMLoader;
import com.sap.engine.services.webservices.wsdl.WSDLDefinitions;
import com.sap.engine.services.webservices.wsdl.WSDLException;
import java.io.IOException;
import org.xml.sax.EntityResolver;

public class WSDLObject {
    private String wsdlURL;
    private EntityResolver metaDataResolver;
    private Object parsedWSDL;

    WSDLObject(String wsdlURL, EntityResolver metaDataResolver) {
        this.wsdlURL = wsdlURL;
        this.metaDataResolver = metaDataResolver;
    }

    WSDLObject(String wsdlURL, Object parsedWSDL) {
        this.wsdlURL = wsdlURL;
        this.parsedWSDL = parsedWSDL;
    }

    public String getURL() {
        return this.wsdlURL;
    }

    public synchronized Object getParsedWSDL() throws IOException, TechnicalException {
        if (this.parsedWSDL == null) {
            try {
                this.parsedWSDL = WSDLObject.getWSDLObject(this.wsdlURL, this.metaDataResolver);
            }
            catch (WSDLException e) {
                throw new TechnicalException((Throwable)((Object)e));
            }
        }
        return this.parsedWSDL;
    }

    private static WSDLDefinitions getWSDLObject(String wsdlURL, EntityResolver wsdlResolver) throws WSDLException {
        WSDLDOMLoader loader = new WSDLDOMLoader();
        if (wsdlResolver != null) {
            loader.setWSDLResolver(wsdlResolver);
        }
        return loader.loadWSDLDocument(wsdlURL);
    }
}

