/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.espbase.query;

import com.sap.engine.services.webservices.espbase.discovery.ServiceDiscovery;
import com.sap.engine.services.webservices.espbase.discovery.TargetNotMappedException;
import com.sap.engine.services.webservices.espbase.query.EngineWSFactory;
import com.sap.engine.services.webservices.espbase.query.ThreadSystem;
import com.sap.engine.services.webservices.espbase.query.WSLogicalDestination;
import com.sap.engine.services.webservices.espbase.query.WSLogicalDestinationImpl;
import com.sap.engine.services.webservices.espbase.query.WSQuery;
import com.sap.engine.services.webservices.espbase.query.WSQueryImpl;
import com.sap.engine.services.webservices.espbase.query.exceptions.ObjectNotExistsException;
import com.sap.engine.services.webservices.espbase.query.exceptions.TechnicalException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class EngineWSFactoryImpl
extends EngineWSFactory {
    private static final String WEBSERVICE_DESTINATION_TYPE = "WebService";
    private static final String WEBSERVICE_DESTINATION_PREFIX = "sap.com/DynamicWSProxies/";
    private static Method getDestinationTypesMethod;
    private static Method getDestinationNamesMethod;
    private ServiceDiscovery serviceDiscovery;
    private ThreadSystem threadSystem;
    private Object dstService;
    static /* synthetic */ Class class$java$lang$String;

    private static void initReflection(Object dstService) throws TechnicalException {
        try {
            ClassLoader loader = dstService.getClass().getClassLoader();
            Class<?> destinationServiceClass = Class.forName("com.sap.security.core.server.destinations.api.DestinationService", true, loader);
            getDestinationTypesMethod = destinationServiceClass.getMethod("getDestinationTypes", new Class[0]);
            getDestinationNamesMethod = destinationServiceClass.getMethod("getDestinationNames", class$java$lang$String == null ? (class$java$lang$String = EngineWSFactoryImpl.class$("java.lang.String")) : class$java$lang$String);
        }
        catch (ClassNotFoundException e) {
            throw new TechnicalException(e);
        }
        catch (NoSuchMethodException e) {
            throw new TechnicalException(e);
        }
    }

    public EngineWSFactoryImpl(Object dstService, ServiceDiscovery serviceDiscovery, ThreadSystem threadSystem) {
        this.dstService = dstService;
        this.serviceDiscovery = serviceDiscovery;
        this.threadSystem = threadSystem;
        EngineWSFactory.setImplementation(this);
    }

    public WSLogicalDestination[] getLogicalDestinations() throws TechnicalException {
        if (getDestinationNamesMethod == null) {
            EngineWSFactoryImpl.initReflection(this.dstService);
        }
        ArrayList<WSLogicalDestinationImpl> result = new ArrayList<WSLogicalDestinationImpl>();
        try {
            List destTypes = (List)getDestinationTypesMethod.invoke(this.dstService, null);
            int i = 0;
            while (i < destTypes.size()) {
                String destType = (String)destTypes.get(i);
                if (WEBSERVICE_DESTINATION_TYPE.equals(destType)) {
                    List destNames = (List)getDestinationNamesMethod.invoke(this.dstService, destType);
                    int j = 0;
                    while (j < destNames.size()) {
                        String destName = (String)destNames.get(j);
                        if (destName.startsWith(WEBSERVICE_DESTINATION_PREFIX)) {
                            destName = destName.substring(WEBSERVICE_DESTINATION_PREFIX.length());
                            int systemType = this.serviceDiscovery.getMappedPhysicalSystemType(destName);
                            result.add(new WSLogicalDestinationImpl(destName, null, systemType));
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        catch (Throwable e) {
            throw new TechnicalException(e);
        }
        return result.toArray(new WSLogicalDestination[result.size()]);
    }

    public WSQuery getWSQuery(String metaDataDestName) throws NullPointerException, ObjectNotExistsException, TechnicalException {
        try {
            return new WSQueryImpl(this.serviceDiscovery.getEntityResolverForTarget(metaDataDestName), this.threadSystem);
        }
        catch (TargetNotMappedException e) {
            throw new TechnicalException((Throwable)((Object)e));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

