/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.espbase.client.dynamic.impl;

import com.sap.engine.lib.xml.parser.URLLoaderBase;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;

public class ServiceClassLoader
extends ClassLoader {
    private String tempDir;

    protected ServiceClassLoader(ClassLoader parent, String tempDir) {
        super(parent);
        this.tempDir = tempDir;
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        String classFileName = this.createClassName(name);
        byte[] classBytes = null;
        try {
            classBytes = this.extractClassBytes(classFileName);
        }
        catch (Exception exc) {
            throw new ClassNotFoundException(exc.getMessage());
        }
        return this.defineClass(classBytes, 0, classBytes.length);
    }

    public URL getResource(String name) {
        URL resourceURL = null;
        try {
            if (name.startsWith("/")) {
                name = name.substring(1);
            }
            resourceURL = URLLoaderBase.fileOrURLToURL(null, (String)(this.tempDir + File.separator + name));
        }
        catch (IOException ioExc) {
            return null;
        }
        return resourceURL;
    }

    private String createClassName(String className) {
        return this.tempDir + File.separator + className.replace('.', File.separatorChar) + ".class";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private byte[] extractClassBytes(String classFilePath) throws Exception {
        byte[] byArray;
        FileInputStream classFileInput = null;
        try {
            File classFile = new File(classFilePath);
            classFileInput = new FileInputStream(classFile);
            byte[] classBytes = new byte[(int)classFile.length()];
            int extractedClassBytesCount = 0;
            while ((extractedClassBytesCount += classFileInput.read(classBytes, extractedClassBytesCount, classBytes.length)) < classBytes.length) {
            }
            byArray = classBytes;
            Object var8_7 = null;
            if (classFileInput == null) return byArray;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (classFileInput == null) throw throwable;
            classFileInput.close();
            throw throwable;
        }
        classFileInput.close();
        return byArray;
    }
}

