/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.espbase.client.dynamic.impl;

import com.sap.engine.services.webservices.espbase.client.dynamic.DOperation;
import com.sap.engine.services.webservices.espbase.client.dynamic.DParameter;
import com.sap.engine.services.webservices.espbase.client.dynamic.impl.DParameterImpl;
import com.sap.engine.services.webservices.jaxrpc.encoding.ExtendedTypeMapping;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.ServiceParam;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.dynamic.OperationStructure;
import java.util.Vector;
import javax.xml.namespace.QName;

public class DOperationImpl
implements DOperation {
    private static final String STYLE_PROEPRTY_NAME = "style";
    private static final String DOCUMENT_STYLE_IDENTIFICATOR = "document";
    private DParameter[] inputParameters;
    private DParameter[] outputParameters;
    private DParameter[] inoutParameters;
    private DParameter[] faultParameters;
    private DParameter returnParameter;
    private String name;

    protected DOperationImpl(OperationStructure operationStructure, ExtendedTypeMapping typeMapping) {
        this.name = operationStructure.operationName;
        this.initParameters(operationStructure, typeMapping);
    }

    private void initParameters(OperationStructure operationStructure, ExtendedTypeMapping typeMapping) {
        String style = (String)operationStructure.bindingConfig.getProperty(STYLE_PROEPRTY_NAME);
        if (style.equals(DOCUMENT_STYLE_IDENTIFICATOR)) {
            this.initParameters_DocumentStyle(operationStructure, typeMapping);
        } else {
            this.initParameters_RPCStyle(operationStructure, typeMapping);
        }
    }

    private void initParameters_DocumentStyle(OperationStructure operationStructure, ExtendedTypeMapping typeMapping) {
        this.inoutParameters = new DParameter[0];
        this.inputParameters = new DParameter[operationStructure.inputParams.length];
        int i = 0;
        while (i < this.inputParameters.length) {
            this.inputParameters[i] = this.createDParameter(operationStructure.inputParams[i], 1, typeMapping);
            ++i;
        }
        if (operationStructure.outputParams.length == 1) {
            this.outputParameters = new DParameter[0];
            this.returnParameter = this.createDParameter(operationStructure.outputParams[0], 4, typeMapping);
        } else {
            this.outputParameters = new DParameter[operationStructure.outputParams.length];
            int i2 = 0;
            while (i2 < this.outputParameters.length) {
                this.outputParameters[i2] = this.createDParameter(operationStructure.outputParams[i2], 2, typeMapping);
                ++i2;
            }
        }
        this.initFaultParameters(operationStructure, typeMapping);
    }

    private DParameter createDParameter(ServiceParam serviceParam, int type, ExtendedTypeMapping typeMapping) {
        QName schemaName = DParameterImpl.determineSchemaName(serviceParam, typeMapping);
        String paramName = DParameterImpl.determineName(serviceParam, type == 5);
        return new DParameterImpl(type, schemaName, paramName, serviceParam.contentClass);
    }

    private void initParameters_RPCStyle(OperationStructure operationStructure, ExtendedTypeMapping typeMapping) {
        Vector<DParameter> inParams = new Vector<DParameter>();
        Vector<DParameter> outParams = new Vector<DParameter>();
        Vector<DParameter> inoutParams = new Vector<DParameter>();
        boolean[] isInoutParamIdentifiers = new boolean[operationStructure.outputParams.length];
        int i = 0;
        while (i < operationStructure.inputParams.length) {
            ServiceParam inputServiceParam = operationStructure.inputParams[i];
            boolean isInout = false;
            int j = 0;
            while (j < operationStructure.outputParams.length) {
                ServiceParam outputServiceParam = operationStructure.outputParams[j];
                if (inputServiceParam.name.equals(outputServiceParam.name)) {
                    inoutParams.add(this.createDParameter(inputServiceParam, 3, typeMapping));
                    isInout = true;
                    isInoutParamIdentifiers[j] = true;
                    break;
                }
                ++j;
            }
            if (!isInout) {
                inParams.add(this.createDParameter(inputServiceParam, 1, typeMapping));
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < operationStructure.outputParams.length) {
            if (!isInoutParamIdentifiers[i2]) {
                ServiceParam outputServiceParam = operationStructure.outputParams[i2];
                outParams.add(this.createDParameter(outputServiceParam, 2, typeMapping));
            }
            ++i2;
        }
        if (outParams.size() == 1 && inoutParams.size() == 0) {
            this.returnParameter = (DParameter)outParams.remove(0);
            ((DParameterImpl)this.returnParameter).setParameterType(4);
        }
        this.inputParameters = new DParameter[inParams.size()];
        inParams.copyInto(this.inputParameters);
        this.outputParameters = new DParameter[outParams.size()];
        outParams.copyInto(this.outputParameters);
        this.inoutParameters = new DParameter[inoutParams.size()];
        inoutParams.copyInto(this.inoutParameters);
        this.initFaultParameters(operationStructure, typeMapping);
    }

    private void initFaultParameters(OperationStructure operationStructure, ExtendedTypeMapping typeMapping) {
        this.faultParameters = new DParameter[operationStructure.faultParams.length];
        int i = 0;
        while (i < operationStructure.faultParams.length) {
            ServiceParam faultParam = operationStructure.faultParams[i];
            this.faultParameters[i] = this.createDParameter(faultParam, 5, typeMapping);
            ++i;
        }
    }

    public DParameter[] getInputParameters() {
        return this.inputParameters;
    }

    public DParameter[] getOutputParameters() {
        return this.outputParameters;
    }

    public DParameter[] getOutputParametes() {
        return this.getOutputParameters();
    }

    public DParameter[] getInOutParameters() {
        return this.inoutParameters;
    }

    public DParameter getReturnParameter() {
        return this.returnParameter;
    }

    public DParameter[] getFaultParameters() {
        return this.faultParameters;
    }

    public String getName() {
        return this.name;
    }
}

