/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.espbase.client.dynamic.impl;

import com.sap.engine.interfaces.webservices.runtime.GlobalClientSettings;
import com.sap.engine.interfaces.webservices.runtime.HTTPProxyResolver;
import com.sap.engine.interfaces.webservices.runtime.component.ClientComponentFactory;
import com.sap.engine.services.webservices.espbase.client.dynamic.DGenericService;
import com.sap.engine.services.webservices.espbase.client.dynamic.DInterface;
import com.sap.engine.services.webservices.espbase.client.dynamic.ServiceFactoryConfig;
import com.sap.engine.services.webservices.espbase.client.dynamic.impl.DInterfaceImpl;
import com.sap.engine.services.webservices.espbase.client.dynamic.impl.ServiceClassLoader;
import com.sap.engine.services.webservices.espbase.client.dynamic.types.impl.MetadataLoader;
import com.sap.engine.services.webservices.jaxrpc.encoding.ExtendedTypeMapping;
import com.sap.engine.services.webservices.jaxrpc.encoding.TypeMappingRegistryImpl;
import com.sap.engine.services.webservices.jaxrpc.exceptions.WebserviceClientException;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.ProxyGenerator;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.ProxyGeneratorConfig;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.ServiceBase;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.lpapi.LogicalPortFactory;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.lpapi.LogicalPortType;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.lpapi.LogicalPorts;
import com.sap.engine.services.webservices.tools.WSDLDownloadResolver;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.xml.namespace.QName;
import javax.xml.rpc.ServiceException;
import org.xml.sax.EntityResolver;

public class DGenericServiceImpl
implements DGenericService {
    private ServiceBase serviceBase;
    private QName[] interfaceNames;
    private Hashtable interfaceToMetadata;
    private String proxyGenerationDir;

    public DGenericServiceImpl(String wsdlURL, ServiceFactoryConfig config) throws ServiceException {
        this.generateProxyFiles(wsdlURL, config);
        this.initPortNameToInterfaceMapping();
    }

    private void initPortNameToInterfaceMapping() throws ServiceException {
        this.interfaceToMetadata = new Hashtable();
        Hashtable<QName, ArrayList> portTypes = new Hashtable<QName, ArrayList>();
        String[] lpNames = this.serviceBase.getLogicalPortNames();
        int i = 0;
        while (i < lpNames.length) {
            ArrayList arr;
            LogicalPortType portType = this.serviceBase.getLogicalPortConfiguration(lpNames[i]);
            QName portTypeName = QName.valueOf(portType.getPTName());
            if (portTypes.containsKey(portTypeName)) {
                arr = (ArrayList)portTypes.get(portTypeName);
                arr.add(new QName(lpNames[i]));
            } else {
                arr = new ArrayList();
                arr.add(new QName(lpNames[i]));
                portTypes.put(portTypeName, arr);
            }
            ++i;
        }
        this.interfaceNames = new QName[portTypes.size()];
        int i2 = 0;
        Enumeration interfaces = portTypes.keys();
        while (interfaces.hasMoreElements()) {
            QName iName;
            this.interfaceNames[i2] = iName = (QName)interfaces.nextElement();
            ArrayList arr = (ArrayList)portTypes.get(iName);
            QName[] portNames = new QName[arr.size()];
            arr.toArray(portNames);
            this.interfaceToMetadata.put(iName, new DInterfaceImpl(iName, portNames, this.serviceBase, this.getTypeMetadata()));
            ++i2;
        }
    }

    private void initProxyGenerationDir(String tempDir) {
        this.proxyGenerationDir = tempDir + File.separator + "DGenService" + System.currentTimeMillis();
        File proxyGenerationDirFile = new File(this.proxyGenerationDir);
        proxyGenerationDirFile.mkdirs();
    }

    private void generateProxyFiles(String wsdlURL, ServiceFactoryConfig config) throws ServiceException {
        if (config.getTemporaryDir() == null) {
            throw new WebserviceClientException("webservices_3608");
        }
        this.initProxyGenerationDir(config.getTemporaryDir());
        ProxyGeneratorConfig proxyGeneratorConfig = new ProxyGeneratorConfig(wsdlURL, this.proxyGenerationDir, "");
        proxyGeneratorConfig.setCompile(true);
        proxyGeneratorConfig.setGenericMode(true);
        if (config.get("DynamicProxy.EntityResolver") != null) {
            proxyGeneratorConfig.setResolver((EntityResolver)config.get("DynamicProxy.EntityResolver"));
        } else {
            WSDLDownloadResolver downLoadResolver = new WSDLDownloadResolver();
            if (config.getPropertyString("DynamicProxy.INetProxy.Host") != null) {
                String excludeLocal;
                downLoadResolver.setProxyHost(config.getPropertyString("DynamicProxy.INetProxy.Host"));
                String proxyPort = config.getPropertyString("DynamicProxy.INetProxy.Port");
                int proxyPortInt = 80;
                if (proxyPort != null) {
                    try {
                        proxyPortInt = Integer.parseInt(proxyPort);
                    }
                    catch (NumberFormatException x) {
                        proxyPortInt = 80;
                    }
                }
                downLoadResolver.setProxyPort(proxyPortInt);
                String excludeHosts = config.getPropertyString("DynamicProxy.INetProxy.Bypass");
                if (excludeHosts != null && excludeHosts.length() != 0) {
                    downLoadResolver.setProxyExcludeList(excludeHosts);
                }
                if ("yes".equalsIgnoreCase(excludeLocal = config.getPropertyString("DynamicProxy.INetProxy.BypasLocal")) || "true".equalsIgnoreCase(excludeLocal)) {
                    downLoadResolver.setProxyBypassLocal(true);
                }
            }
            if (config.getPropertyString("DynamicProxy.HTTPUserName") != null) {
                downLoadResolver.setUsername(config.getPropertyString("DynamicProxy.HTTPUserName"));
                downLoadResolver.setPassword(config.getPropertyString("DynamicProxy.HTTPPassword"));
            }
            proxyGeneratorConfig.setResolver(downLoadResolver);
        }
        proxyGeneratorConfig.setAdditionalClassPath(config.getAdditionalClassPath());
        ClientComponentFactory componentFactory = (ClientComponentFactory)config.get("DynamicProxy.ComponentFactory");
        ProxyGenerator proxyGenerator = new ProxyGenerator();
        try {
            proxyGenerator.generateProxy(proxyGeneratorConfig);
            this.initServiceBase(proxyGeneratorConfig, componentFactory, config);
        }
        catch (Exception x) {
            throw new WebserviceClientException("webservices_3609", x);
        }
    }

    private void initServiceBase(ProxyGeneratorConfig proxyGeneratorConfig, ClientComponentFactory componentFactory, ServiceFactoryConfig config) throws Exception {
        LogicalPortFactory plfactory = new LogicalPortFactory();
        LogicalPorts logicalPorts = plfactory.loadLogicalPorts(this.proxyGenerationDir + File.separator + "lports.xml");
        String serviceBaseImplClassName = logicalPorts.getImplementationName();
        ServiceClassLoader serviceClassLoader = new ServiceClassLoader(this.getClass().getClassLoader(), this.proxyGenerationDir);
        Class<?> serviceClass = serviceClassLoader.loadClass(serviceBaseImplClassName);
        this.serviceBase = (ServiceBase)serviceClass.newInstance();
        if (componentFactory != null) {
            this.serviceBase._setComponentFactory(componentFactory);
        }
        if (config.get("DynamicProxy.HTTPProxyResolver") != null) {
            this.serviceBase.setHTTPProxyResolver((HTTPProxyResolver)config.get("DynamicProxy.HTTPProxyResolver"));
        }
        if (config.get("DynamicProxy.HTTPClientSettings") != null) {
            this.serviceBase.setGlobalClientSettings((GlobalClientSettings)config.get("DynamicProxy.HTTPClientSettings"));
        }
        this.serviceBase._setWSDLDefinitions(proxyGeneratorConfig.getDefinitions());
        MetadataLoader.LoadMetaData((TypeMappingRegistryImpl)this.serviceBase.getTypeMappingRegistry(), serviceClassLoader);
    }

    public void stop() {
        this.deleteProxyGenerationDir();
    }

    private void deleteProxyGenerationDir() {
        File proxyGenerationDirFile = new File(this.proxyGenerationDir);
        this.deleteDir(proxyGenerationDirFile);
    }

    private void deleteDir(File dirFile) {
        File[] files = dirFile.listFiles();
        if (files != null) {
            int i = 0;
            while (i < files.length) {
                File file = files[i];
                if (file.isFile()) {
                    file.delete();
                } else if (file.isDirectory()) {
                    this.deleteDir(file);
                }
                ++i;
            }
        }
        dirFile.delete();
    }

    public String getProxyGenerationDir() {
        return this.proxyGenerationDir;
    }

    public ExtendedTypeMapping getTypeMetadata() {
        return (ExtendedTypeMapping)this.serviceBase.getTypeMappingRegistry().getDefaultTypeMapping();
    }

    public QName[] getInterfaces() {
        return this.interfaceNames;
    }

    public DInterface getInterfaceMetadata(QName interfaceName) {
        return (DInterface)this.interfaceToMetadata.get(interfaceName);
    }
}

