/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.espbase.client.dynamic.gui;

import com.sap.engine.services.webservices.espbase.client.dynamic.DGenericService;
import com.sap.engine.services.webservices.espbase.client.dynamic.GenericServiceFactory;
import com.sap.engine.services.webservices.espbase.client.dynamic.ServiceFactoryConfig;
import com.sap.engine.services.webservices.espbase.client.dynamic.gui.MetadataVisualFrame;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class ServiceFactoryManagementPanel
extends JPanel
implements ActionListener {
    private static final String OPEN_WSDL_ACTION_COMMAND = "open.wsdl.action";
    private static final String OPEN_TEMP_DIR_ACTION_COMMAND = "open.temp.dir.action";
    private static final String CREATE_ACTION_COMMAND = "create.action";
    private JTextField tempDirField;
    private JTextField addClasspathField;
    private JTextField proxyHostField;
    private JTextField proxyPortField;
    private JTextField proxyBypassField;
    private JTextField javacPathField;
    private JTextField wsdlPathField;
    private GenericServiceFactory serviceFactory;
    private MetadataVisualFrame metadataVisualFrame;
    private JTextArea errorTextArea;

    protected ServiceFactoryManagementPanel(MetadataVisualFrame metadataVisualFrame) {
        this.metadataVisualFrame = metadataVisualFrame;
        this.serviceFactory = GenericServiceFactory.newInstance();
        this.visualInit();
    }

    private void visualInit() {
        Insets insets;
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstr = new GridBagConstraints();
        gridBagConstr.fill = 2;
        gridBagConstr.anchor = 17;
        gridBagConstr.insets = insets = new Insets(5, 5, 0, 5);
        this.tempDirField = new JTextField();
        this.addClasspathField = new JTextField();
        this.proxyHostField = new JTextField();
        this.proxyPortField = new JTextField();
        this.proxyBypassField = new JTextField();
        this.javacPathField = new JTextField();
        this.wsdlPathField = new JTextField();
        this.addJLabel(gridBagConstr, 0, "temporary dir: ");
        this.addFileManagementPanel(this.tempDirField, gridBagConstr, 0, OPEN_TEMP_DIR_ACTION_COMMAND);
        insets.top = 0;
        this.addJLabel(gridBagConstr, 1, "additional classpath: ");
        this.addJTextField(gridBagConstr, 1, this.addClasspathField);
        this.addJLabel(gridBagConstr, 2, "proxy host: ");
        this.addJTextField(gridBagConstr, 2, this.proxyHostField);
        this.addJLabel(gridBagConstr, 3, "proxy port: ");
        this.addJTextField(gridBagConstr, 3, this.proxyPortField);
        this.addJLabel(gridBagConstr, 4, "proxy bypass: ");
        this.addJTextField(gridBagConstr, 4, this.proxyBypassField);
        this.addJLabel(gridBagConstr, 5, "javac path: ");
        this.addJTextField(gridBagConstr, 5, this.javacPathField);
        this.addJLabel(gridBagConstr, 6, "wsdl path: ");
        this.addFileManagementPanel(this.wsdlPathField, gridBagConstr, 6, OPEN_WSDL_ACTION_COMMAND);
        gridBagConstr.gridx = 0;
        gridBagConstr.gridy = 7;
        gridBagConstr.weightx = 0.0;
        JButton createButton = new JButton("create");
        createButton.setActionCommand(CREATE_ACTION_COMMAND);
        createButton.addActionListener(this);
        this.add((Component)createButton, gridBagConstr);
        gridBagConstr.gridy = 8;
        insets.top = 5;
        this.add((Component)new JLabel("Errors:"), gridBagConstr);
        insets.top = 0;
        insets.bottom = 5;
        gridBagConstr.anchor = 10;
        gridBagConstr.fill = 1;
        gridBagConstr.gridy = 9;
        gridBagConstr.gridwidth = 2;
        gridBagConstr.weightx = 1.0;
        gridBagConstr.weighty = 1.0;
        this.errorTextArea = new JTextArea();
        JScrollPane scrollPane = new JScrollPane(this.errorTextArea);
        this.add((Component)scrollPane, gridBagConstr);
    }

    private void addFileManagementPanel(JTextField textField, GridBagConstraints gridBagConstr, int gridy, String actionCommand) {
        JPanel managementPanel = this.createFileManagementPanel(textField, actionCommand);
        gridBagConstr.gridx = 1;
        gridBagConstr.gridy = gridy;
        gridBagConstr.weightx = 1.0;
        this.add((Component)managementPanel, gridBagConstr);
    }

    private JPanel createFileManagementPanel(JTextField textField, String actionCommand) {
        JPanel wsdlManagementPanel = new JPanel();
        wsdlManagementPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstr = new GridBagConstraints();
        gridBagConstr.fill = 2;
        gridBagConstr.gridx = 0;
        gridBagConstr.weightx = 1.0;
        wsdlManagementPanel.add((Component)textField, gridBagConstr);
        gridBagConstr.gridx = 1;
        gridBagConstr.weightx = 0.0;
        JButton openButton = new JButton("open");
        openButton.setActionCommand(actionCommand);
        openButton.addActionListener(this);
        wsdlManagementPanel.add((Component)openButton, gridBagConstr);
        return wsdlManagementPanel;
    }

    private void addJLabel(GridBagConstraints gridBagConstr, int gridy, String label) {
        gridBagConstr.gridx = 0;
        gridBagConstr.gridy = gridy;
        gridBagConstr.weightx = 0.0;
        this.add((Component)new JLabel(label), gridBagConstr);
    }

    private void addJTextField(GridBagConstraints gridBagConstr, int gridy, JTextField textField) {
        gridBagConstr.gridx = 1;
        gridBagConstr.gridy = gridy;
        gridBagConstr.weightx = 1.0;
        this.add((Component)textField, gridBagConstr);
    }

    protected ServiceFactoryConfig createServiceFactoryConfig() {
        ServiceFactoryConfig serviceFactoryCfg = new ServiceFactoryConfig();
        this.setServiceFactoryCfgProperty(serviceFactoryCfg, this.tempDirField, "DynamicProxy.TempDir");
        this.setServiceFactoryCfgProperty(serviceFactoryCfg, this.addClasspathField, "DynamicProxy.ClassPath");
        this.setServiceFactoryCfgProperty(serviceFactoryCfg, this.proxyHostField, "DynamicProxy.INetProxy.Host");
        this.setServiceFactoryCfgProperty(serviceFactoryCfg, this.proxyPortField, "DynamicProxy.INetProxy.Port");
        this.setServiceFactoryCfgProperty(serviceFactoryCfg, this.proxyBypassField, "DynamicProxy.INetProxy.Bypass");
        this.setServiceFactoryCfgProperty(serviceFactoryCfg, this.javacPathField, "DynamicProxy.Javac.path");
        return serviceFactoryCfg;
    }

    private void setServiceFactoryCfgProperty(ServiceFactoryConfig serviceFactoryCfg, JTextField textFi\u00e5ld, String key) {
        String value = textFi\u00e5ld.getText();
        if (value.equals("")) {
            serviceFactoryCfg.remove(key);
        } else {
            serviceFactoryCfg.setPropertyString(key, value);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String actionCommand = actionEvent.getActionCommand();
        if (actionCommand.equals(OPEN_WSDL_ACTION_COMMAND)) {
            this.performChooseFile(this.wsdlPathField, 0);
        } else if (actionCommand.equals(OPEN_TEMP_DIR_ACTION_COMMAND)) {
            this.performChooseFile(this.tempDirField, 1);
        } else if (actionCommand.equals(CREATE_ACTION_COMMAND)) {
            this.createAndVisualizeMetadata();
        }
    }

    private void performChooseFile(JTextField textField, int fileSelectionMode) {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setFileSelectionMode(fileSelectionMode);
        int fileChooseResult = fileChooser.showOpenDialog(this);
        File choosedFile = fileChooser.getSelectedFile();
        if (choosedFile != null) {
            try {
                textField.setText(choosedFile.getCanonicalPath());
            }
            catch (Exception exc) {
                exc.printStackTrace();
            }
        }
    }

    private void createAndVisualizeMetadata() {
        try {
            this.errorTextArea.setText("");
            DGenericService service = this.serviceFactory.createService(this.wsdlPathField.getText(), this.createServiceFactoryConfig());
            this.metadataVisualFrame.visualizeService(service);
        }
        catch (Exception exc) {
            this.displayError(exc);
        }
    }

    private void displayError(Throwable tr) {
        this.errorTextArea.append(tr.toString() + "\n");
        ByteArrayOutputStream throwableByteArrayOutput = new ByteArrayOutputStream();
        PrintStream throwablePrintStream = new PrintStream(throwableByteArrayOutput);
        tr.printStackTrace(throwablePrintStream);
        throwablePrintStream.flush();
        this.errorTextArea.append(new String(throwableByteArrayOutput.toByteArray()) + "\n");
        throwablePrintStream.close();
    }
}

