/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.espbase.client.dynamic.gui;

import com.sap.engine.services.webservices.espbase.client.dynamic.DGenericService;
import com.sap.engine.services.webservices.espbase.client.dynamic.DInterface;
import com.sap.engine.services.webservices.espbase.client.dynamic.DOperation;
import com.sap.engine.services.webservices.espbase.client.dynamic.DParameter;
import com.sap.engine.services.webservices.espbase.client.dynamic.GenericServiceFactory;
import com.sap.engine.services.webservices.espbase.client.dynamic.ServiceFactoryConfig;
import com.sap.engine.services.webservices.espbase.client.dynamic.types.DAny;
import com.sap.engine.services.webservices.espbase.client.dynamic.types.DAttribute;
import com.sap.engine.services.webservices.espbase.client.dynamic.types.DBaseType;
import com.sap.engine.services.webservices.espbase.client.dynamic.types.DComplexType;
import com.sap.engine.services.webservices.espbase.client.dynamic.types.DElement;
import com.sap.engine.services.webservices.espbase.client.dynamic.types.DField;
import com.sap.engine.services.webservices.espbase.client.dynamic.types.DGroup;
import com.sap.engine.services.webservices.espbase.client.dynamic.types.DNamedNode;
import com.sap.engine.services.webservices.espbase.client.dynamic.types.DSimpleContent;
import com.sap.engine.services.webservices.espbase.client.dynamic.types.DSimpleType;
import com.sap.engine.services.webservices.espbase.client.dynamic.types.DStructure;
import com.sap.engine.services.webservices.espbase.client.dynamic.types.Facet;
import com.sap.engine.services.webservices.jaxrpc.encoding.ExtendedTypeMapping;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Enumeration;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.xml.namespace.QName;

public class MetadataVisualPanel
extends JPanel {
    private JScrollPane treeVisualizationScrollPane;

    protected MetadataVisualPanel() {
        this.setLayout(new GridBagLayout());
        Insets insets = new Insets(5, 5, 0, 5);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = insets;
        gridBagConstraints.anchor = 17;
        this.add((Component)new JLabel("Metadata:"), gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 1;
        insets.bottom = 5;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.treeVisualizationScrollPane = new JScrollPane();
        this.add((Component)this.treeVisualizationScrollPane, gridBagConstraints);
    }

    protected void visualize(String wsdlURL, String workingDir) throws Exception {
        ServiceFactoryConfig serviceFactoryConfig = new ServiceFactoryConfig();
        serviceFactoryConfig.setTemporaryDir(workingDir);
        DGenericService dGenericService = GenericServiceFactory.newInstance().createService(wsdlURL, serviceFactoryConfig);
        this.visualize(dGenericService);
    }

    protected void visualize(DGenericService service) {
        JTree visualizationTree = new JTree(this.createServiceNode(service));
        visualizationTree.setVisible(true);
        this.treeVisualizationScrollPane.getViewport().add(visualizationTree);
        this.treeVisualizationScrollPane.repaint();
    }

    private DefaultMutableTreeNode createServiceNode(DGenericService service) {
        DefaultMutableTreeNode serviceNode = new DefaultMutableTreeNode("service");
        serviceNode.add(this.createTypeMappingNode(service.getTypeMetadata()));
        serviceNode.add(this.createInterfacesNode(service));
        return serviceNode;
    }

    private DefaultMutableTreeNode createInterfacesNode(DGenericService service) {
        DefaultMutableTreeNode interfacesNode = new DefaultMutableTreeNode("interfaces");
        QName[] portNames = service.getInterfaces();
        int i = 0;
        while (i < portNames.length) {
            DInterface _interface = service.getInterfaceMetadata(portNames[i]);
            interfacesNode.add(this.createInterfaceNode(_interface));
            ++i;
        }
        return interfacesNode;
    }

    private DefaultMutableTreeNode createInterfaceNode(DInterface _interface) {
        DefaultMutableTreeNode interfaceNode = new DefaultMutableTreeNode("interface : " + _interface.getInterfaceName());
        interfaceNode.add(new DefaultMutableTreeNode(this.createInterfaceLPortsNode(_interface)));
        interfaceNode.add(new DefaultMutableTreeNode("interface name : " + _interface.getInterfaceName()));
        interfaceNode.add(this.createOperationsNode(_interface));
        return interfaceNode;
    }

    private DefaultMutableTreeNode createInterfaceLPortsNode(DInterface _interface) {
        DefaultMutableTreeNode interfaceLPortsNode = new DefaultMutableTreeNode("logical ports");
        QName[] lPortNames = _interface.getPortNames();
        int i = 0;
        while (i < lPortNames.length) {
            QName lportName = lPortNames[i];
            interfaceLPortsNode.add(new DefaultMutableTreeNode("logical port : " + lportName));
            ++i;
        }
        return interfaceLPortsNode;
    }

    private DefaultMutableTreeNode createOperationsNode(DInterface _interface) {
        DefaultMutableTreeNode operationsNode = new DefaultMutableTreeNode("operations");
        DOperation[] operations = _interface.getOperations();
        int i = 0;
        while (i < operations.length) {
            DOperation operation = operations[i];
            operationsNode.add(this.createOperationNode(operation));
            ++i;
        }
        return operationsNode;
    }

    private DefaultMutableTreeNode createOperationNode(DOperation operation) {
        DefaultMutableTreeNode operationNode = new DefaultMutableTreeNode("operation : " + operation.getName());
        operationNode.add(this.createInputParamsNode(operation));
        operationNode.add(this.createOutputParamsNode(operation));
        operationNode.add(this.createInOutParamsNode(operation));
        operationNode.add(this.createFaultParamsNode(operation));
        operationNode.add(this.createReturnParamNode(operation));
        operationNode.add(new DefaultMutableTreeNode("name : " + operation.getName()));
        return operationNode;
    }

    private DefaultMutableTreeNode createInputParamsNode(DOperation operation) {
        DefaultMutableTreeNode inputParamsNode = new DefaultMutableTreeNode("input params");
        DParameter[] inputParams = operation.getInputParameters();
        this.initWithParameters(inputParamsNode, inputParams);
        return inputParamsNode;
    }

    private DefaultMutableTreeNode createOutputParamsNode(DOperation operation) {
        DefaultMutableTreeNode outputParamsNode = new DefaultMutableTreeNode("output params");
        DParameter[] outputParams = operation.getOutputParameters();
        this.initWithParameters(outputParamsNode, outputParams);
        return outputParamsNode;
    }

    private DefaultMutableTreeNode createInOutParamsNode(DOperation operation) {
        DefaultMutableTreeNode inoutParamsNode = new DefaultMutableTreeNode("inout params");
        DParameter[] inoutParams = operation.getInOutParameters();
        this.initWithParameters(inoutParamsNode, inoutParams);
        return inoutParamsNode;
    }

    private DefaultMutableTreeNode createFaultParamsNode(DOperation operation) {
        DefaultMutableTreeNode faulParamsNode = new DefaultMutableTreeNode("fault params");
        DParameter[] faultParams = operation.getFaultParameters();
        this.initWithParameters(faulParamsNode, faultParams);
        return faulParamsNode;
    }

    private DefaultMutableTreeNode createReturnParamNode(DOperation operation) {
        DefaultMutableTreeNode returnParamsNode = new DefaultMutableTreeNode("return param");
        DParameter returnParameter = operation.getReturnParameter();
        if (returnParameter != null) {
            returnParamsNode.add(this.createParameterNode(returnParameter));
        }
        return returnParamsNode;
    }

    private void initWithParameters(DefaultMutableTreeNode node, DParameter[] params) {
        int i = 0;
        while (i < params.length) {
            DParameter parameter = params[i];
            node.add(this.createParameterNode(parameter));
            ++i;
        }
    }

    private DefaultMutableTreeNode createParameterNode(DParameter parameter) {
        DefaultMutableTreeNode parameterNode = new DefaultMutableTreeNode("parameter : " + parameter.getName());
        parameterNode.add(new DefaultMutableTreeNode("type : " + parameter.getParameterType()));
        parameterNode.add(new DefaultMutableTreeNode("schema name : " + parameter.getSchemaName()));
        parameterNode.add(new DefaultMutableTreeNode("name : " + parameter.getName()));
        parameterNode.add(new DefaultMutableTreeNode("param class : " + parameter.getParameterClass()));
        return parameterNode;
    }

    private DefaultMutableTreeNode createTypeMappingNode(ExtendedTypeMapping typeMapping) {
        DefaultMutableTreeNode typeMappingNode = new DefaultMutableTreeNode("type mapping");
        Enumeration typesEnum = typeMapping.getRegisteredSchemaTypes();
        while (typesEnum.hasMoreElements()) {
            QName typeName = (QName)typesEnum.nextElement();
            DBaseType type = typeMapping.getTypeMetadata(typeName);
            if (type == null) continue;
            typeMappingNode.add(this.createBaseTypeNode(type));
        }
        return typeMappingNode;
    }

    private DefaultMutableTreeNode createBaseTypeNode(DBaseType type) {
        if (type instanceof DComplexType) {
            return this.createComplexTypeNode((DComplexType)type);
        }
        return this.createSimpleTypeNode((DSimpleType)type);
    }

    private DefaultMutableTreeNode createComplexTypeNode(DComplexType type) {
        DefaultMutableTreeNode complexTypeNode = new DefaultMutableTreeNode("Complex Type : " + type.getTypeName());
        this.initWithBaseType(complexTypeNode, type);
        switch (type.getType()) {
            case 4: {
                complexTypeNode.add(new DefaultMutableTreeNode("Content : UNORDERED"));
                break;
            }
            case 3: {
                complexTypeNode.add(new DefaultMutableTreeNode("Content : ORDERED"));
                break;
            }
            case 2: {
                complexTypeNode.add(new DefaultMutableTreeNode("Content : CHOICE"));
                break;
            }
            case 0: {
                complexTypeNode.add(new DefaultMutableTreeNode("Content : SIMPLE Content"));
            }
        }
        this.initWithStructure(complexTypeNode, type);
        complexTypeNode.add(this.createAttributesNode(type));
        return complexTypeNode;
    }

    public void initWithBaseType(DefaultMutableTreeNode node, DBaseType baseType) {
        node.add(new DefaultMutableTreeNode("Base Type: " + baseType.getBaseTypeName()));
        node.add(new DefaultMutableTreeNode("BuiltIn : " + baseType.isBuiltIn()));
        node.add(new DefaultMutableTreeNode("Anonymous : " + baseType.isAnonymous()));
    }

    public void initWithStructure(DefaultMutableTreeNode node, DStructure structure) {
        node.add(this.createFieldsNode(structure));
    }

    private DefaultMutableTreeNode createFieldsNode(DStructure structure) {
        DefaultMutableTreeNode fieldsNode = new DefaultMutableTreeNode("fields");
        DField[] fields = structure.getFields();
        int i = 0;
        while (i < fields.length) {
            fieldsNode.add(this.createFieldNode(fields[i]));
            ++i;
        }
        return fieldsNode;
    }

    private DefaultMutableTreeNode createFieldNode(DField field) {
        if (field instanceof DElement) {
            return this.createElementNode((DElement)field);
        }
        if (field instanceof DAttribute) {
            return this.createAttributeNode((DAttribute)field);
        }
        if (field instanceof DGroup) {
            return this.createGroupNode((DGroup)field);
        }
        if (field instanceof DSimpleContent) {
            return this.createSimpleContentNode((DSimpleContent)field);
        }
        return this.createAnyNode((DAny)field);
    }

    private DefaultMutableTreeNode createElementNode(DElement element) {
        DefaultMutableTreeNode elementNode = new DefaultMutableTreeNode("element : " + element.getFieldName());
        this.initWithField(elementNode, element);
        this.initWithNamedNode(elementNode, element);
        elementNode.add(new DefaultMutableTreeNode("min occurs : " + element.getMinOccurs()));
        elementNode.add(new DefaultMutableTreeNode("max occurs : " + element.getMaxOccurs()));
        elementNode.add(new DefaultMutableTreeNode("is nillable : " + element.isNillable()));
        elementNode.add(new DefaultMutableTreeNode("default value : " + element.getDefaultValue()));
        return elementNode;
    }

    private void initWithField(DefaultMutableTreeNode node, DField field) {
        if (field == null) {
            node.add(new DefaultMutableTreeNode("null"));
        } else {
            node.add(new DefaultMutableTreeNode("type : " + field.getType()));
            node.add(new DefaultMutableTreeNode("field type : " + field.getFieldType()));
            node.add(new DefaultMutableTreeNode("field scope : " + field.getFieldScope()));
        }
    }

    private void initWithNamedNode(DefaultMutableTreeNode node, DNamedNode namedNode) {
        node.add(new DefaultMutableTreeNode("field name : " + namedNode.getFieldName()));
    }

    private DefaultMutableTreeNode createAttributeNode(DAttribute attrib) {
        DefaultMutableTreeNode attribNode = new DefaultMutableTreeNode("attribute : " + attrib.getFieldName());
        this.initWithField(attribNode, attrib);
        this.initWithNamedNode(attribNode, attrib);
        attribNode.add(new DefaultMutableTreeNode("is required : " + attrib.isRequired()));
        attribNode.add(new DefaultMutableTreeNode("default value : " + attrib.getDefaultValue()));
        return attribNode;
    }

    private DefaultMutableTreeNode createGroupNode(DGroup group) {
        DefaultMutableTreeNode groupNode = new DefaultMutableTreeNode("group : " + group.getFieldName());
        groupNode.add(new DefaultMutableTreeNode("min occurs : " + group.getMinOccurs()));
        groupNode.add(new DefaultMutableTreeNode("max occurs : " + group.getMaxOccurs()));
        groupNode.add(new DefaultMutableTreeNode("field scope : " + group.getFieldScope()));
        switch (group.getType()) {
            case 4: {
                groupNode.add(new DefaultMutableTreeNode("Content : UNORDERED"));
                break;
            }
            case 3: {
                groupNode.add(new DefaultMutableTreeNode("Content : ORDERED"));
                break;
            }
            case 2: {
                groupNode.add(new DefaultMutableTreeNode("Content : CHOICE"));
                break;
            }
            case 0: {
                groupNode.add(new DefaultMutableTreeNode("Content : SIMPLE Content"));
            }
        }
        this.initWithNamedNode(groupNode, group);
        this.initWithStructure(groupNode, group);
        return groupNode;
    }

    private DefaultMutableTreeNode createSimpleContentNode(DSimpleContent simpleContent) {
        DefaultMutableTreeNode simpleContentNode = new DefaultMutableTreeNode("simple content : " + simpleContent.getFieldName());
        this.initWithField(simpleContentNode, simpleContent);
        this.initWithNamedNode(simpleContentNode, simpleContent);
        return simpleContentNode;
    }

    private DefaultMutableTreeNode createAnyNode(DAny any) {
        DefaultMutableTreeNode anyNode = new DefaultMutableTreeNode("any");
        this.initWithField(anyNode, any);
        this.initWithNamedNode(anyNode, any);
        anyNode.add(new DefaultMutableTreeNode("min occurs : " + any.getMinOccurs()));
        anyNode.add(new DefaultMutableTreeNode("max occurs : " + any.getMaxOccurs()));
        return anyNode;
    }

    private DefaultMutableTreeNode createAttributesNode(DComplexType complexType) {
        DefaultMutableTreeNode attributesNode = new DefaultMutableTreeNode("attributes");
        DField[] attributes = complexType.getAttributes();
        int i = 0;
        while (i < attributes.length) {
            DField field = attributes[i];
            attributesNode.add(this.createFieldNode(field));
            ++i;
        }
        return attributesNode;
    }

    private DefaultMutableTreeNode createSimpleTypeNode(DSimpleType simpleType) {
        DefaultMutableTreeNode simpleTypeNode = new DefaultMutableTreeNode("Simple Type : " + simpleType.getTypeName());
        this.initWithBaseType(simpleTypeNode, simpleType);
        switch (simpleType.getType()) {
            case 1: {
                simpleTypeNode.add(new DefaultMutableTreeNode("CONTENT : LIST"));
                break;
            }
            case 0: {
                simpleTypeNode.add(new DefaultMutableTreeNode("CONTENT : RESTRICTION"));
            }
        }
        simpleTypeNode.add(this.createFacetsNode(simpleType));
        return simpleTypeNode;
    }

    private DefaultMutableTreeNode createFacetsNode(DSimpleType simpleType) {
        DefaultMutableTreeNode simpleTypeNode = new DefaultMutableTreeNode("facets");
        Facet[] facets = simpleType.getFacets();
        int i = 0;
        while (i < facets.length) {
            Facet facet = facets[i];
            simpleTypeNode.add(this.createFacetNode(facet));
            ++i;
        }
        return simpleTypeNode;
    }

    private DefaultMutableTreeNode createFacetNode(Facet facet) {
        DefaultMutableTreeNode facetNode = new DefaultMutableTreeNode("facet");
        facetNode.add(new DefaultMutableTreeNode("name : " + facet.getName()));
        facetNode.add(new DefaultMutableTreeNode("value : " + facet.getValue()));
        facetNode.add(new DefaultMutableTreeNode("int value : " + facet.getIntValue()));
        facetNode.add(new DefaultMutableTreeNode("object value : " + facet.getObjectValue()));
        return facetNode;
    }
}

