/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.webservices.espbase.client.dynamic;

import com.sap.engine.interfaces.webservices.runtime.component.ClientComponentFactory;
import com.sap.engine.services.webservices.espbase.client.dynamic.DGenericService;
import com.sap.engine.services.webservices.espbase.client.dynamic.J2EEEngineHelper;
import com.sap.engine.services.webservices.espbase.client.dynamic.ServiceFactoryConfig;
import com.sap.engine.services.webservices.espbase.client.dynamic.impl.DGenericServiceImpl;
import com.sap.engine.services.webservices.espbase.discovery.ServiceDiscovery;
import com.sap.engine.services.webservices.espbase.discovery.TargetConfigurationException;
import com.sap.engine.services.webservices.espbase.discovery.TargetNotMappedException;
import com.sap.engine.services.webservices.jaxrpc.exceptions.accessors.XmlSerializationResourceAccessor;
import com.sap.exception.BaseRuntimeException;
import com.sap.tc.logging.Location;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.xml.namespace.QName;
import javax.xml.rpc.ServiceException;

public class GenericServiceFactory {
    public static J2EEEngineHelper engineHelper;
    private static final Location LOCATION;
    private static final String METHOD_NOT_AVAILABLE = "webservices_3610";
    private Hashtable wsdlURLToServiceMapping = new Hashtable();
    private static final GenericServiceFactory singletonFactory;
    private ServiceDiscovery serviceDiscovery;
    static /* synthetic */ Class class$com$sap$engine$services$webservices$espbase$client$dynamic$GenericServiceFactory;

    private GenericServiceFactory() {
    }

    public static GenericServiceFactory newInstance() {
        return singletonFactory;
    }

    public DGenericService createService(String wsdlURL, ServiceFactoryConfig config) throws ServiceException {
        DGenericService service = (DGenericService)this.wsdlURLToServiceMapping.get(wsdlURL);
        if (service == null) {
            if (engineHelper != null) {
                ClientComponentFactory componentFactory = engineHelper.getClientComponentFactory();
                config.put("DynamicProxy.ComponentFactory", componentFactory);
            }
            service = new DGenericServiceImpl(wsdlURL, config);
            if (engineHelper != null) {
                config.remove("DynamicProxy.ComponentFactory");
            }
            this.wsdlURLToServiceMapping.put(wsdlURL, service);
        }
        return service;
    }

    public DGenericService createService(String wsdlUrl) throws ServiceException {
        if (engineHelper == null) {
            throw new BaseRuntimeException(LOCATION, XmlSerializationResourceAccessor.getResourceAccessor(), METHOD_NOT_AVAILABLE, new Object[]{"createService(String lmtName, QName interfaceName)"});
        }
        ServiceFactoryConfig config = engineHelper.getServiceFactoryConfig();
        return this.createService(wsdlUrl, config);
    }

    public DGenericService createService(String lmtName, QName interfaceName) throws TargetNotMappedException, IOException, TargetConfigurationException, ServiceException {
        String wsdlUrl;
        if (engineHelper == null) {
            throw new BaseRuntimeException(LOCATION, XmlSerializationResourceAccessor.getResourceAccessor(), METHOD_NOT_AVAILABLE, new Object[]{"createService(String lmtName, QName interfaceName)"});
        }
        if (this.serviceDiscovery == null) {
            GenericServiceFactory genericServiceFactory = this;
            synchronized (genericServiceFactory) {
                if (this.serviceDiscovery == null) {
                    this.serviceDiscovery = engineHelper.getServiceDiscovery();
                }
            }
        }
        if ((wsdlUrl = this.serviceDiscovery.getWSDLUrl(lmtName, interfaceName)) == null) {
            throw new ServiceException("Web Service " + interfaceName + " not found via destination " + lmtName + ". Please, check that the physical destination points to a system, containing a web service with such a name.");
        }
        ServiceFactoryConfig config = engineHelper.getServiceFactoryConfig();
        config.put("DynamicProxy.EntityResolver", this.serviceDiscovery.getEntityResolverForTarget(lmtName));
        return this.createService(wsdlUrl, config);
    }

    public void stop() {
        Enumeration serviceEnum = this.wsdlURLToServiceMapping.elements();
        while (serviceEnum.hasMoreElements()) {
            DGenericServiceImpl service = (DGenericServiceImpl)serviceEnum.nextElement();
            service.stop();
        }
        this.wsdlURLToServiceMapping.clear();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        LOCATION = Location.getLocation((Class)(class$com$sap$engine$services$webservices$espbase$client$dynamic$GenericServiceFactory == null ? (class$com$sap$engine$services$webservices$espbase$client$dynamic$GenericServiceFactory = GenericServiceFactory.class$("com.sap.engine.services.webservices.espbase.client.dynamic.GenericServiceFactory")) : class$com$sap$engine$services$webservices$espbase$client$dynamic$GenericServiceFactory));
        singletonFactory = new GenericServiceFactory();
    }
}

