/*
 * Decompiled with CFR 0.152.
 */
package iaik.x509.ocsp.utils;

import iaik.utils.Util;
import iaik.x509.X509Certificate;
import iaik.x509.ocsp.ResponderID;
import java.util.Hashtable;

public class TrustedResponders {
    private Hashtable a = new Hashtable();

    public boolean removeTrustedResponderEntry(ResponderID responderID, X509Certificate x509Certificate) {
        X509Certificate[] x509CertificateArray = (X509Certificate[])this.a.get(responderID);
        if (x509CertificateArray != null && x509CertificateArray.length > 0) {
            int n = x509CertificateArray.length;
            if (n == 1) {
                if (x509CertificateArray[0].equals(x509Certificate)) {
                    return this.removeTrustedResponder(responderID);
                }
                return false;
            }
            int n2 = 0;
            while (n2 < n) {
                if (x509CertificateArray[n2].equals(x509Certificate)) {
                    x509CertificateArray[n2] = null;
                    X509Certificate[] x509CertificateArray2 = new X509Certificate[n - 1];
                    int n3 = 0;
                    while (n3 < n - 1) {
                        x509CertificateArray2[n3] = x509CertificateArray[n3] == null ? x509CertificateArray[n3 + 1] : x509CertificateArray[n3];
                        ++n3;
                    }
                    this.a.put(responderID, x509CertificateArray2);
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public boolean removeTrustedResponder(ResponderID responderID) {
        return this.a.remove(responderID) != null;
    }

    public boolean isTrustedResponder(ResponderID responderID, X509Certificate x509Certificate, X509Certificate x509Certificate2) {
        X509Certificate[] x509CertificateArray = (X509Certificate[])this.a.get(responderID);
        if (x509CertificateArray != null && x509CertificateArray.length > 0) {
            int n = 0;
            while (n < x509CertificateArray.length) {
                if (x509CertificateArray[n].equals(x509Certificate2) && x509Certificate.getIssuerDN().equals(x509Certificate2.getSubjectDN())) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    public void clearAllEntries() {
        this.a.clear();
    }

    public boolean addTrustedResponderEntry(ResponderID responderID, X509Certificate x509Certificate) {
        int n;
        Object[] objectArray = (X509Certificate[])this.a.get(responderID);
        if (objectArray != null && objectArray.length > 0) {
            n = 0;
            while (n < objectArray.length) {
                if (objectArray[n].equals(x509Certificate)) {
                    return false;
                }
                ++n;
            }
            objectArray = (X509Certificate[])Util.resizeArray(objectArray, objectArray.length + 1);
            objectArray[objectArray.length - 1] = x509Certificate;
        } else {
            objectArray = new X509Certificate[]{x509Certificate};
        }
        int n2 = n = this.a.put(responderID, objectArray) != null ? 1 : 0;
        return n != 0 || objectArray.length == 1;
    }
}

