/*
 * Decompiled with CFR 0.152.
 */
package iaik.x509.ocsp;

import demo.keystore.IaikKeyStore;
import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.CON_SPEC;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.OCTET_STRING;
import iaik.asn1.structures.AlgorithmID;
import iaik.asn1.structures.GeneralName;
import iaik.asn1.structures.Name;
import iaik.pkcs.pkcs7.IssuerAndSerialNumber;
import iaik.security.md.SHA;
import iaik.security.provider.IAIK;
import iaik.utils.CryptoUtils;
import iaik.utils.InternalErrorException;
import iaik.utils.Util;
import iaik.x509.X509Certificate;
import iaik.x509.ocsp.CertID;
import iaik.x509.ocsp.OCSPException;

public class ReqCert {
    private Object b;
    private int a = -1;
    public static final int certHash = 4;
    public static final int name = 3;
    public static final int pKCert = 2;
    public static final int issuerSerial = 1;
    public static final int certID = 0;
    private static final boolean c = false;

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        switch (this.a) {
            case 0: {
                stringBuffer.append("certID: ");
                break;
            }
            case 1: {
                stringBuffer.append("issuerSerial: ");
                break;
            }
            case 2: {
                stringBuffer.append("pKCert: ");
                break;
            }
            case 3: {
                stringBuffer.append("name: ");
                break;
            }
            case 4: {
                stringBuffer.append("certHash: ");
                break;
            }
            default: {
                stringBuffer.append("undefined");
            }
        }
        if (this.a >= 0) {
            if (this.a == 4) {
                stringBuffer.append(Util.toString((byte[])this.b));
            } else {
                stringBuffer.append("{" + this.b.toString() + "}");
            }
        }
        return stringBuffer.toString();
    }

    public ASN1Object toASN1Object() throws CodingException {
        ASN1Object aSN1Object = null;
        switch (this.a) {
            case 0: {
                aSN1Object = ((CertID)this.b).toASN1Object();
                break;
            }
            case 1: {
                aSN1Object = new CON_SPEC(0, ((IssuerAndSerialNumber)this.b).toASN1Object());
                break;
            }
            case 2: {
                aSN1Object = new CON_SPEC(1, ((X509Certificate)this.b).toASN1Object());
                break;
            }
            case 3: {
                aSN1Object = new CON_SPEC(2, ((GeneralName)this.b).toASN1Object());
                break;
            }
            case 4: {
                aSN1Object = new CON_SPEC(3, new OCTET_STRING((byte[])this.b));
                break;
            }
            default: {
                throw new InternalErrorException("Unknown reqCert type: " + this.a + "!");
            }
        }
        return aSN1Object;
    }

    public static void main(String[] stringArray) {
        try {
            IAIK.addAsProvider();
            X509Certificate[] x509CertificateArray = IaikKeyStore.getCertificateChain((int)0, (int)0);
            X509Certificate[] x509CertificateArray2 = IaikKeyStore.getCertificateChain((int)0, (int)1);
            CertID certID = new CertID(AlgorithmID.sha1, x509CertificateArray[1], x509CertificateArray[0]);
            new CertID(AlgorithmID.sha1, x509CertificateArray[1], x509CertificateArray[0]);
            ReqCert reqCert = new ReqCert(0, certID);
            System.out.println(reqCert);
            ReqCert reqCert2 = new ReqCert(0, certID);
            byte[] byArray = DerCoder.encode(reqCert2.toASN1Object());
            ASN1Object aSN1Object = DerCoder.decode(byArray);
            reqCert2 = new ReqCert(aSN1Object);
            System.out.println(reqCert2);
            System.out.println(reqCert2.getType());
            System.out.println(reqCert2.getTypeName());
            System.out.println(reqCert2.hashCode());
            System.out.println(reqCert2.equals(reqCert));
            System.out.println(reqCert2.isReqCertFor(x509CertificateArray[0], x509CertificateArray[1], null));
            System.out.println(reqCert2.isReqCertFor(x509CertificateArray2[0], x509CertificateArray2[1], null));
            System.out.println(reqCert2.isReqCertFor(x509CertificateArray[0], null, null));
            reqCert = new ReqCert(1, new IssuerAndSerialNumber(x509CertificateArray[0]));
            System.out.println(reqCert);
            reqCert2 = new ReqCert(1, new IssuerAndSerialNumber(x509CertificateArray[0]));
            byArray = DerCoder.encode(reqCert2.toASN1Object());
            aSN1Object = DerCoder.decode(byArray);
            reqCert2 = new ReqCert(aSN1Object);
            System.out.println(reqCert2);
            System.out.println(reqCert2.getType());
            System.out.println(reqCert2.getTypeName());
            System.out.println(reqCert2.hashCode());
            System.out.println(reqCert2.equals(reqCert));
            System.out.println(reqCert2.isReqCertFor(x509CertificateArray[0], null, null));
            System.out.println(reqCert2.isReqCertFor(x509CertificateArray[1], null, null));
            System.out.println(reqCert2.isReqCertFor(null, null, null));
            reqCert = new ReqCert(2, x509CertificateArray[0]);
            System.out.println(reqCert);
            reqCert2 = new ReqCert(2, x509CertificateArray[0]);
            byArray = DerCoder.encode(reqCert2.toASN1Object());
            aSN1Object = DerCoder.decode(byArray);
            reqCert2 = new ReqCert(aSN1Object);
            System.out.println(reqCert2);
            System.out.println(reqCert2.getType());
            System.out.println(reqCert2.getTypeName());
            System.out.println(reqCert2.hashCode());
            System.out.println(reqCert2.equals(reqCert));
            System.out.println(reqCert2.isReqCertFor(x509CertificateArray[0], null, null));
            System.out.println(reqCert2.isReqCertFor(x509CertificateArray[1], null, null));
            System.out.println(reqCert2.isReqCertFor(null, null, null));
            GeneralName generalName = new GeneralName(1, "jd@ksd");
            GeneralName generalName2 = new GeneralName(1, "jd@ksd");
            GeneralName generalName3 = new GeneralName(1, "j1@ksd");
            reqCert = new ReqCert(3, generalName);
            System.out.println(reqCert);
            reqCert2 = new ReqCert(3, generalName2);
            byArray = DerCoder.encode(reqCert2.toASN1Object());
            aSN1Object = DerCoder.decode(byArray);
            reqCert2 = new ReqCert(aSN1Object);
            System.out.println(reqCert2);
            System.out.println(reqCert2.getType());
            System.out.println(reqCert2.getTypeName());
            System.out.println(reqCert2.hashCode());
            System.out.println(reqCert2.equals(reqCert));
            System.out.println(reqCert2.isReqCertFor(null, null, generalName));
            System.out.println(reqCert2.isReqCertFor(null, null, generalName2));
            System.out.println(reqCert2.isReqCertFor(null, null, generalName3));
            System.out.println(reqCert2.isReqCertFor(x509CertificateArray[0], null, null));
            System.out.println(reqCert2.isReqCertFor(x509CertificateArray[1], null, null));
            reqCert = new ReqCert(4, x509CertificateArray[0]);
            System.out.println(reqCert);
            reqCert2 = new ReqCert(4, x509CertificateArray[0]);
            byArray = DerCoder.encode(reqCert2.toASN1Object());
            aSN1Object = DerCoder.decode(byArray);
            reqCert2 = new ReqCert(aSN1Object);
            System.out.println(reqCert2);
            System.out.println(reqCert2.getType());
            System.out.println(reqCert2.getTypeName());
            System.out.println(reqCert2.hashCode());
            System.out.println(reqCert2.equals(reqCert));
            System.out.println(reqCert2.isReqCertFor(null, null, generalName));
            System.out.println(reqCert2.isReqCertFor(null, null, generalName2));
            System.out.println(reqCert2.isReqCertFor(null, null, generalName3));
            System.out.println(reqCert2.isReqCertFor(x509CertificateArray[0], null, null));
            System.out.println(reqCert2.isReqCertFor(x509CertificateArray[1], null, null));
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public boolean isReqCertFor(X509Certificate x509Certificate, X509Certificate x509Certificate2, GeneralName generalName) throws OCSPException {
        boolean bl = false;
        try {
            switch (this.a) {
                case 0: {
                    if (x509Certificate != null && x509Certificate2 != null) {
                        bl = ((CertID)this.b).isCertIDFor((Name)x509Certificate2.getSubjectDN(), x509Certificate2.getPublicKey(), x509Certificate.getSerialNumber());
                    }
                    break;
                }
                case 1: {
                    if (x509Certificate != null) {
                        IssuerAndSerialNumber issuerAndSerialNumber = new IssuerAndSerialNumber(x509Certificate);
                        bl = issuerAndSerialNumber.equals((IssuerAndSerialNumber)this.b);
                    }
                    break;
                }
                case 2: {
                    if (x509Certificate != null) {
                        bl = x509Certificate.equals((X509Certificate)this.b);
                    }
                    break;
                }
                case 3: {
                    if (generalName != null) {
                        bl = generalName.equals((GeneralName)this.b);
                        break;
                    }
                    if (x509Certificate != null) {
                        GeneralName generalName2 = new GeneralName(4, x509Certificate.getSubjectDN());
                        bl = generalName2.equals((GeneralName)this.b);
                    }
                    break;
                }
                case 4: {
                    if (x509Certificate != null) {
                        byte[] byArray = ReqCert.a(x509Certificate.getEncoded());
                        bl = CryptoUtils.equalsBlock((byte[])this.b, byArray);
                    }
                    break;
                }
                default: {
                    bl = false;
                    break;
                }
            }
        }
        catch (Exception exception) {
            throw new OCSPException(exception.getMessage());
        }
        return bl;
    }

    public int hashCode() {
        int n = this.a;
        switch (this.a) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                n += this.b.hashCode();
                break;
            }
            case 4: {
                n += Util.calculateHashCode((byte[])this.b);
                break;
            }
            default: {
                n += "undefined".hashCode();
            }
        }
        return n;
    }

    public String getTypeName() {
        String string = null;
        switch (this.a) {
            case 0: {
                string = "certID";
                break;
            }
            case 1: {
                string = "issuerSerial";
                break;
            }
            case 2: {
                string = "pKCert";
                break;
            }
            case 3: {
                string = "name";
                break;
            }
            case 4: {
                string = "certHash";
                break;
            }
            default: {
                string = "undefined";
            }
        }
        return string;
    }

    public int getType() {
        return this.a;
    }

    public Object getReqCert() {
        return this.b;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ReqCert)) {
            return false;
        }
        ReqCert reqCert = (ReqCert)object;
        if (this.a != reqCert.a) {
            return false;
        }
        if (this.a == 4) {
            return CryptoUtils.equalsBlock((byte[])this.b, (byte[])reqCert.b);
        }
        return this.b.equals(reqCert.b);
    }

    private void a(ASN1Object aSN1Object) throws CodingException {
        if (!aSN1Object.isA(ASN.CON_SPEC)) {
            this.b = new CertID(aSN1Object);
            this.a = 0;
            return;
        }
        CON_SPEC cON_SPEC = (CON_SPEC)aSN1Object;
        this.a = cON_SPEC.getAsnType().getTag();
        ASN1Object aSN1Object2 = (ASN1Object)cON_SPEC.getValue();
        switch (this.a) {
            case 0: {
                this.b = new IssuerAndSerialNumber(aSN1Object2);
                break;
            }
            case 1: {
                this.b = new X509Certificate();
                ((X509Certificate)this.b).decode(aSN1Object2);
                break;
            }
            case 2: {
                this.b = new GeneralName(aSN1Object2);
                break;
            }
            case 3: {
                this.b = aSN1Object2.getValue();
                break;
            }
            default: {
                throw new CodingException("Cannot parse ReqCert! Illegal type specification: Type has to be in the range of 0...4!");
            }
        }
        ++this.a;
    }

    private static byte[] a(byte[] byArray) {
        SHA sHA = new SHA();
        return sHA.digest(byArray);
    }

    public ReqCert(ASN1Object aSN1Object) throws CodingException {
        this.a(aSN1Object);
    }

    public ReqCert(int n, Object object) throws IllegalArgumentException {
        switch (n) {
            case 0: {
                if (object instanceof CertID) break;
                throw new IllegalArgumentException("Cannot create ReqCert! Expecting OCSP certID object for type certID!");
            }
            case 1: {
                if (object instanceof IssuerAndSerialNumber) break;
                throw new IllegalArgumentException("Cannot create ReqCert! Expecting IssuerAndSerialNumber object for type issuerSerial!");
            }
            case 2: {
                if (object instanceof X509Certificate) break;
                throw new IllegalArgumentException("Cannot create ReqCert! Expecting X509Certificate object for type pKCert!");
            }
            case 3: {
                if (object instanceof GeneralName) break;
                throw new IllegalArgumentException("Cannot create ReqCert! Expecting GeneralName object for type name!");
            }
            case 4: {
                if (object instanceof X509Certificate) {
                    try {
                        this.b = ReqCert.a(((X509Certificate)object).getEncoded());
                        break;
                    }
                    catch (Exception exception) {
                        throw new IllegalArgumentException("Cannot create cert hash for cert: " + exception.getMessage());
                    }
                }
                if (object instanceof byte[]) {
                    this.b = object;
                    break;
                }
                throw new IllegalArgumentException("Cannot create ReqCert! Expecting X509Certificate or byte array for type certHash!");
            }
            default: {
                throw new IllegalArgumentException("Cannot create ReqCert! Illegal type specification! Type has to be in the range of 0...4!");
            }
        }
        if (n != 4) {
            this.b = object;
        }
        this.a = n;
    }
}

