/*
 * Decompiled with CFR 0.152.
 */
package iaik.x509.extensions;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.CON_SPEC;
import iaik.asn1.CodingException;
import iaik.asn1.INTEGER;
import iaik.asn1.OCTET_STRING;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.GeneralNames;
import iaik.utils.Util;
import iaik.x509.V3Extension;
import iaik.x509.X509ExtensionException;
import java.math.BigInteger;

public class AuthorityKeyIdentifier
extends V3Extension {
    private BigInteger b;
    private GeneralNames c;
    private byte[] a;
    public static final ObjectID oid = new ObjectID("2.5.29.35", "AuthorityKeyIdentifier");

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.a != null) {
            stringBuffer.append("KeyIdentifier: " + Util.toString(this.a) + "\n");
        }
        if (this.c != null) {
            stringBuffer.append("AuthorityCertIssuer: " + this.c + "\n");
        }
        if (this.b != null) {
            stringBuffer.append("AuthorityCertSerialNumber: " + this.b.toString(16) + "\n");
        }
        stringBuffer.setLength(stringBuffer.length() - 1);
        return stringBuffer.toString();
    }

    public ASN1Object toASN1Object() throws X509ExtensionException {
        boolean bl = true;
        SEQUENCE sEQUENCE = new SEQUENCE();
        if (this.a != null) {
            sEQUENCE.addComponent(new CON_SPEC(0, new OCTET_STRING(this.a), bl));
        }
        if (this.c != null) {
            try {
                sEQUENCE.addComponent(new CON_SPEC(1, this.c.toASN1Object(), bl));
            }
            catch (CodingException codingException) {
                throw new X509ExtensionException(codingException.getMessage());
            }
        }
        if (this.b != null) {
            sEQUENCE.addComponent(new CON_SPEC(2, new INTEGER(this.b), bl));
        }
        return sEQUENCE;
    }

    public void setKeyIdentifier(byte[] byArray) {
        this.a = byArray;
    }

    public void setAuthorityCertSerialNumber(BigInteger bigInteger) {
        this.b = bigInteger;
    }

    public void setAuthorityCertIssuer(GeneralNames generalNames) {
        this.c = generalNames;
    }

    public void init(ASN1Object aSN1Object) throws X509ExtensionException {
        ASN1Object aSN1Object2 = null;
        try {
            int n = 0;
            while (n < aSN1Object.countComponents()) {
                CON_SPEC cON_SPEC = (CON_SPEC)aSN1Object.getComponentAt(n);
                switch (cON_SPEC.getAsnType().getTag()) {
                    case 0: {
                        OCTET_STRING oCTET_STRING = null;
                        if (cON_SPEC.isImplicitlyTagged()) {
                            cON_SPEC.forceImplicitlyTagged(ASN.OCTET_STRING);
                        }
                        if (!((aSN1Object2 = (ASN1Object)cON_SPEC.getValue()) instanceof OCTET_STRING)) {
                            throw new CodingException("Cannot parse keyIdentifier. Expected an OCTET_STRING!");
                        }
                        oCTET_STRING = (OCTET_STRING)aSN1Object2;
                        this.a = (byte[])oCTET_STRING.getValue();
                        break;
                    }
                    case 1: {
                        Object object = cON_SPEC.getValue();
                        if (!(object instanceof ASN1Object) || !((ASN1Object)object).getAsnType().equals(ASN.SEQUENCE)) {
                            cON_SPEC.forceImplicitlyTagged(ASN.SEQUENCE);
                        }
                        aSN1Object2 = (ASN1Object)cON_SPEC.getValue();
                        this.c = new GeneralNames(aSN1Object2);
                        break;
                    }
                    case 2: {
                        INTEGER iNTEGER = null;
                        if (cON_SPEC.isImplicitlyTagged()) {
                            cON_SPEC.forceImplicitlyTagged(ASN.INTEGER);
                        }
                        if (!((aSN1Object2 = (ASN1Object)cON_SPEC.getValue()) instanceof INTEGER)) {
                            throw new CodingException("Cannot parse authorityCertSerialNumber. Expected an INTEGER!");
                        }
                        iNTEGER = (INTEGER)aSN1Object2;
                        this.b = (BigInteger)iNTEGER.getValue();
                        break;
                    }
                }
                ++n;
            }
            return;
        }
        catch (Exception exception) {
            throw new X509ExtensionException(exception.getMessage());
        }
    }

    public int hashCode() {
        return oid.hashCode();
    }

    public ObjectID getObjectID() {
        return oid;
    }

    public byte[] getKeyIdentifier() {
        return this.a;
    }

    public BigInteger getAuthorityCertSerialNumber() {
        return this.b;
    }

    public GeneralNames getAuthorityCertIssuer() {
        return this.c;
    }

    public AuthorityKeyIdentifier(byte[] byArray) {
        this.a = byArray;
    }

    public AuthorityKeyIdentifier(GeneralNames generalNames, BigInteger bigInteger) {
        this.c = generalNames;
        this.b = bigInteger;
    }

    public AuthorityKeyIdentifier() {
    }
}

