/*
 * Decompiled with CFR 0.152.
 */
package iaik.x509;

import iaik.asn1.ObjectID;
import iaik.x509.V3Extension;
import iaik.x509.X509Certificate;
import iaik.x509.extensions.AuthorityKeyIdentifier;
import iaik.x509.extensions.BasicConstraints;
import iaik.x509.extensions.CRLDistributionPoints;
import iaik.x509.extensions.CRLNumber;
import iaik.x509.extensions.ExtendedKeyUsage;
import iaik.x509.extensions.IssuerAltName;
import iaik.x509.extensions.KeyUsage;
import iaik.x509.extensions.PolicyConstraints;
import iaik.x509.extensions.PolicyMappings;
import iaik.x509.extensions.ReasonCode;
import iaik.x509.extensions.SubjectAltName;
import iaik.x509.extensions.SubjectKeyIdentifier;
import iaik.x509.extensions.netscape.NetscapeBaseUrl;
import iaik.x509.extensions.netscape.NetscapeCaPolicyUrl;
import iaik.x509.extensions.netscape.NetscapeCaRevocationUrl;
import iaik.x509.extensions.netscape.NetscapeCertRenewalUrl;
import iaik.x509.extensions.netscape.NetscapeComment;
import iaik.x509.extensions.netscape.NetscapeRevocationUrl;
import iaik.x509.extensions.netscape.NetscapeSSLServerName;
import java.security.Principal;
import java.security.cert.CertificateException;
import java.util.Enumeration;
import java.util.Vector;

public abstract class ChainVerifier {
    private static final boolean a = false;
    private static final boolean b = false;

    public boolean verifyChain(java.security.cert.X509Certificate[] x509CertificateArray, boolean bl) throws CertificateException {
        int n = x509CertificateArray.length;
        if (bl) {
            java.security.cert.X509Certificate[] x509CertificateArray2 = new java.security.cert.X509Certificate[n];
            int n2 = 0;
            while (n2 < n) {
                x509CertificateArray2[n2] = x509CertificateArray[n - n2 - 1];
                ++n2;
            }
            x509CertificateArray = x509CertificateArray2;
        }
        try {
            int n3 = 0;
            while (n3 < n) {
                if (n3 > 0) {
                    if (!x509CertificateArray[n3].getSubjectDN().equals(x509CertificateArray[n3 - 1].getIssuerDN())) {
                        throw new CertificateException("Certificate chain broken: not linked correctly");
                    }
                    x509CertificateArray[n3 - 1].verify(x509CertificateArray[n3].getPublicKey());
                }
                if (x509CertificateArray[n3].getSubjectDN().equals(x509CertificateArray[n3].getIssuerDN())) {
                    x509CertificateArray[n3].verify(x509CertificateArray[n3].getPublicKey());
                }
                this.checkExtensions(x509CertificateArray, n3);
                if (this.isTrustedCertificate(x509CertificateArray[n3])) {
                    return true;
                }
                x509CertificateArray[n3].checkValidity();
                ++n3;
            }
        }
        catch (CertificateException certificateException) {
            throw certificateException;
        }
        catch (Exception exception) {
            throw new CertificateException("Error in certificate chain");
        }
        return false;
    }

    public boolean verifyChain(java.security.cert.X509Certificate[] x509CertificateArray) throws CertificateException {
        return this.verifyChain(x509CertificateArray, false);
    }

    public static java.security.cert.X509Certificate[] orderCertificateChain(java.security.cert.X509Certificate x509Certificate, java.security.cert.X509Certificate[] x509CertificateArray) throws CertificateException {
        Principal principal;
        Object[] objectArray;
        Principal principal2;
        java.security.cert.X509Certificate[] x509CertificateArray2 = (java.security.cert.X509Certificate[])x509CertificateArray.clone();
        Vector<java.security.cert.X509Certificate> vector = new Vector<java.security.cert.X509Certificate>();
        vector.addElement(x509Certificate);
        Enumeration enumeration = vector.elements();
        while (!(principal2 = (objectArray = (Object[])enumeration.nextElement()).getSubjectDN()).equals(principal = objectArray.getIssuerDN())) {
            int n = 0;
            while (n < x509CertificateArray2.length) {
                if (x509CertificateArray2[n] != null && x509CertificateArray2[n].getSubjectDN().equals(principal)) {
                    vector.addElement(x509CertificateArray2[n]);
                    x509CertificateArray2[n] = null;
                    break;
                }
                ++n;
            }
            if (n != x509CertificateArray.length) continue;
            throw new CertificateException("Certificate chain incomplete, no certificate found for " + principal);
        }
        objectArray = new java.security.cert.X509Certificate[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public abstract boolean isTrustedCertificate(java.security.cert.X509Certificate var1) throws CertificateException;

    protected void checkExtensions(java.security.cert.X509Certificate[] x509CertificateArray, int n) throws CertificateException {
        if (!(x509CertificateArray[n] instanceof X509Certificate)) {
            return;
        }
        Enumeration enumeration = ((X509Certificate)x509CertificateArray[n]).listExtensions();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                int n2;
                V3Extension v3Extension;
                V3Extension v3Extension2 = (V3Extension)enumeration.nextElement();
                ObjectID objectID = v3Extension2.getObjectID();
                if (objectID.equals(BasicConstraints.oid)) {
                    v3Extension = (BasicConstraints)v3Extension2;
                    if (((BasicConstraints)v3Extension).ca()) {
                        if (n == 0) {
                            throw new CertificateException("Extension error: certificate at index 0 is marked CA certificate");
                        }
                        n2 = ((BasicConstraints)v3Extension).getPathLenConstraint();
                        if (n2 == -1 || n2 >= n - 1) continue;
                        throw new CertificateException("Extension error: pathLenConstraint violated!");
                    }
                    if (n == 0) continue;
                    throw new CertificateException("Extension error: certificate at index " + n + " is marked as non-CA certificate");
                }
                if (objectID.equals(KeyUsage.oid)) {
                    v3Extension = (KeyUsage)v3Extension2;
                    if (n <= 0 || ((n2 = ((KeyUsage)v3Extension).get()) & 0x20) != 0) continue;
                    throw new CertificateException("Extension error: keyusage does not allow certificate signing");
                }
                if (objectID.equals(AuthorityKeyIdentifier.oid) || objectID.equals(CRLDistributionPoints.oid) || objectID.equals(CRLNumber.oid) || objectID.equals(ExtendedKeyUsage.oid) || objectID.equals(IssuerAltName.oid) || objectID.equals(PolicyMappings.oid) || objectID.equals(ReasonCode.oid) || objectID.equals(PolicyConstraints.oid) || objectID.equals(SubjectAltName.oid) || objectID.equals(SubjectKeyIdentifier.oid) || objectID.equals(NetscapeBaseUrl.oid) || objectID.equals(NetscapeCaPolicyUrl.oid) || objectID.equals(NetscapeCaRevocationUrl.oid) || objectID.equals(NetscapeCertRenewalUrl.oid) || objectID.equals(NetscapeComment.oid) || objectID.equals(NetscapeRevocationUrl.oid) || objectID.equals(NetscapeSSLServerName.oid) || !v3Extension2.isCritical()) continue;
                throw new CertificateException("Unhandled CRITICAL extension: " + v3Extension2.getObjectID());
            }
        }
    }

    protected ChainVerifier() {
    }
}

