/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.random;

import iaik.security.random.RandomException;
import iaik.security.random.RandomInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Random;

public class FIPS140Test {
    private static final float e = 57.4f;
    private static final float f = 1.03f;
    private static final int j = 34;
    private static final int[] b;
    private static final int[] c;
    private static final int h = 10346;
    private static final int i = 9654;
    PrintWriter l;
    static int[] g;
    InputStream d;
    byte[] a;
    private static final int k = 2500;
    private static final int m = 20000;

    public boolean startTests(boolean bl) {
        this.a("initializing...");
        try {
            this.initTests();
        }
        catch (RandomException randomException) {
            this.a(randomException.getMessage());
            return false;
        }
        boolean bl2 = true;
        if (!bl && !(bl2 &= this.monoBitTest())) {
            return false;
        }
        if (!bl && !(bl2 &= this.pokerTest())) {
            return false;
        }
        if (!bl && !(bl2 &= this.runsTest())) {
            return false;
        }
        if (!bl && !(bl2 &= this.longRunsTest())) {
            return false;
        }
        if (bl2) {
            this.a("all tests passed");
        }
        return bl2;
    }

    public boolean startTests() {
        return this.startTests(false);
    }

    public void setDebugStream(PrintWriter printWriter) {
        this.l = printWriter;
    }

    public void setDebugStream(PrintStream printStream) {
        if (printStream == null) {
            this.l = null;
            return;
        }
        this.l = new PrintWriter(printStream);
    }

    public boolean runsTest() {
        this.a("running runs test");
        int[] nArray = new int[7];
        int[] nArray2 = new int[7];
        int[][] nArrayArray = new int[][]{nArray, nArray2};
        int n = this.a(0);
        int n2 = 0;
        int n3 = 0;
        while (n3 < 20000) {
            if (n == this.a(n3)) {
                ++n2;
            } else {
                if (n2 > 6) {
                    n2 = 6;
                }
                int[] nArray3 = nArrayArray[n];
                int n4 = n2;
                nArray3[n4] = nArray3[n4] + 1;
                n ^= 1;
                n2 = 0;
            }
            ++n3;
        }
        int n5 = 1;
        while (n5 <= 6) {
            this.a("blocks/gaps of length " + n5 + ": " + nArray2[n5] + "/" + nArray[n5]);
            ++n5;
        }
        int n6 = 1;
        while (n6 <= 6) {
            if (!this.a(nArray[n6] + nArray2[n6], c[n6], b[n6])) {
                this.a("runs of length " + n6 + " failed test: not " + c[n6] + " < " + (nArray[n6] + nArray2[n6]) + " < " + b[n6]);
                this.a("runs test FAILED");
                return false;
            }
            ++n6;
        }
        this.a("runs test passed");
        return true;
    }

    public boolean runTests() {
        return this.startTests();
    }

    private void a(Object object) {
        if (this.l != null) {
            this.l.println("FIPS140Test: " + object);
            this.l.flush();
        }
    }

    public boolean pokerTest() {
        this.a("running poker test");
        int[] nArray = new int[16];
        int n = 0;
        while (n < 2500) {
            int n2 = (this.a[n] & 0xF0) >> 4;
            nArray[n2] = nArray[n2] + 1;
            int n3 = this.a[n] & 0xF;
            nArray[n3] = nArray[n3] + 1;
            ++n;
        }
        long l = 0L;
        int n4 = 0;
        while (n4 <= 15) {
            l += (long)(nArray[n4] * nArray[n4]);
            ++n4;
        }
        int n5 = 5000;
        float f2 = 16.0f / (float)n5 * (float)l - (float)n5;
        this.a("poker test result: " + 1.03f + " < " + f2 + " < " + 57.4f);
        boolean bl = f2 > 1.03f && f2 < 57.4f;
        this.a("poker test " + (bl ? "passed" : "FAILED!"));
        return bl;
    }

    public boolean monoBitTest() {
        this.a("running monobit test...");
        this.a();
        int n = 0;
        int n2 = 0;
        while (n2 < 2500) {
            n += g[this.a[n2] & 0xFF];
            ++n2;
        }
        this.a("number of one bits: " + 9654 + " < " + n + " < " + 10346);
        if (this.a(n, 9654, 10346)) {
            this.a("monobit test passed");
            return true;
        }
        this.a("monobit test FAILED!");
        return false;
    }

    private void a() {
        if (g != null) {
            return;
        }
        g = new int[256];
        int n = 0;
        while (n < 256) {
            int n2 = 0;
            int n3 = n;
            while (n3 != 0) {
                if ((n3 & 1) != 0) {
                    ++n2;
                }
                n3 >>= 1;
            }
            FIPS140Test.g[n] = n2;
            ++n;
        }
    }

    public boolean longRunsTest() {
        this.a("running long runs test");
        int n = this.a(0);
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n4 < 20000) {
            if (n == this.a(n4)) {
                ++n2;
            } else {
                if (n2 >= 34) {
                    this.a("long run of length " + n2 + " detected");
                    this.a("long runs test FAILED");
                    return false;
                }
                if (n2 > n3) {
                    n3 = n2;
                }
                n ^= 1;
                n2 = 0;
            }
            ++n4;
        }
        this.a("longest run: " + n3);
        this.a("long runs test passed");
        return true;
    }

    public void initTests() throws RandomException {
        try {
            int n = this.d.read(this.a);
            if (n != this.a.length) {
                throw new IOException();
            }
        }
        catch (IOException iOException) {
            throw new RandomException("Error reading random data!");
        }
    }

    private int a(int n) {
        int n2 = n >> 3;
        int n3 = n & 7;
        return (this.a[n2] & 0xFF) >>> 7 - n3 & 1;
    }

    private boolean a(int n, int n2, int n3) {
        return n > n2 && n < n3;
    }

    public FIPS140Test(Random random) {
        this(new RandomInputStream(random));
    }

    public FIPS140Test(InputStream inputStream) {
        this.d = inputStream;
        this.a = new byte[2500];
    }

    static {
        int[] nArray = new int[7];
        nArray[1] = 2267;
        nArray[2] = 1079;
        nArray[3] = 502;
        nArray[4] = 223;
        nArray[5] = 90;
        nArray[6] = 90;
        c = nArray;
        int[] nArray2 = new int[7];
        nArray2[1] = 2733;
        nArray2[2] = 1421;
        nArray2[3] = 748;
        nArray2[4] = 402;
        nArray2[5] = 223;
        nArray2[6] = 223;
        b = nArray2;
    }
}

