/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.provider;

import iaik.security.md.Md5;
import iaik.security.md.Md5Old;
import iaik.utils.ExtendedProvider;
import java.security.MessageDigest;
import java.security.Provider;
import java.security.Security;
import java.util.Hashtable;
import java.util.Properties;
import javax.crypto.Cipher;

public final class IAIK
extends ExtendedProvider {
    public static final double version = 3.01;
    private static final String info = "IAIK Security Provider v3.01, evaluation version, debug mode";
    private static final boolean DEBUG = false;
    private static boolean useOldMd5 = false;
    private static IAIK instance;

    public IAIK() {
        super("IAIK", 3.01, info);
        instance = this;
        try {
            Class.forName("java.security.spec.KeySpec");
            Class.forName("java.security.GeneralSecurityException");
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException("Unable to find required JDK1.2 classes.");
        }
        this.addAlgorithms();
    }

    private void addAlgorithms() {
        this.puta("MessageDigest.MD2", "iaik.security.md.Md2");
        this.putc("MessageDigest.MD5", "iaik.security.md.Md5Old", useOldMd5);
        this.putc("MessageDigest.MD5", "iaik.security.md.Md5", !useOldMd5);
        this.puta("MessageDigest.SHA-1", "iaik.security.md.SHA");
        this.puta("Alg.Alias.MessageDigest.SHA", "SHA-1");
        this.puta("Alg.Alias.MessageDigest.1.3.14.3.2.18", "SHA-1");
        this.puta("Alg.Alias.MessageDigest.SHA1", "SHA-1");
        this.puta("MessageDigest.RIPEMD128", "iaik.security.md.RipeMd128");
        this.puta("Alg.Alias.MessageDigest.RipeMd128", "RIPEMD128");
        this.puta("Alg.Alias.MessageDigest.RIPEMD-128", "RIPEMD128");
        this.puta("Alg.Alias.MessageDigest.1.3.36.3.2.2", "RIPEMD128");
        this.puta("MessageDigest.RIPEMD160", "iaik.security.md.RipeMd160");
        this.puta("Alg.Alias.MessageDigest.RipeMd160", "RIPEMD160");
        this.puta("Alg.Alias.MessageDigest.RIPEMD-160", "RIPEMD160");
        this.puta("Alg.Alias.MessageDigest.1.3.36.3.2.1", "RIPEMD160");
        this.puta("MessageDigest.SHA256", "iaik.security.md.SHA256");
        this.puta("MessageDigest.SHA384", "iaik.security.md.SHA384");
        this.puta("MessageDigest.SHA512", "iaik.security.md.SHA512");
        this.puta("Alg.Alias.MessageDigest.SHA-256", "SHA256");
        this.puta("Alg.Alias.MessageDigest.SHA-384", "SHA384");
        this.puta("Alg.Alias.MessageDigest.SHA-512", "SHA512");
        this.puta("Signature.RawDSA", "iaik.security.dsa.RawDSA");
        this.puta("Signature.DSA", "iaik.security.dsa.DSA");
        this.puta("Alg.Alias.Signature.SHA/DSA", "DSA");
        this.puta("Alg.Alias.Signature.SHA-1/DSA", "DSA");
        this.puta("Alg.Alias.Signature.SHA1/DSA", "DSA");
        this.puta("Alg.Alias.Signature.DSS", "DSA");
        this.puta("Alg.Alias.Signature.1.3.14.3.2.13", "DSA");
        this.puta("Alg.Alias.Signature.1.3.14.3.2.27", "DSA");
        this.puta("Alg.Alias.Signature.1.2.840.10040.4.3", "DSA");
        this.puta("Alg.Alias.Signature.SHAwithDSA", "DSA");
        this.puta("Alg.Alias.Signature.SHA1withDSA", "DSA");
        this.puta("KeyPairGenerator.DH", "iaik.security.dh.DHKeyPairGenerator");
        this.puta("Alg.Alias.KeyPairGenerator.DiffieHellman", "DH");
        this.puta("KeyPairGenerator.ESDH", "iaik.security.dh.ESDHKeyPairGenerator");
        this.puta("Alg.Alias.KeyPairGenerator.ESDiffieHellman", "ESDH");
        this.puta("KeyPairGenerator.DSA", "iaik.security.dsa.DSAKeyPairGenerator");
        this.puta("Alg.Alias.KeyPairGenerator.1.3.14.3.2.12", "DSA");
        this.puta("Alg.Alias.KeyPairGenerator.1.2.840.10040.4.1", "DSA");
        this.puta("KeyGenerator.PKCS#12", "iaik.pkcs.pkcs12.SecretKeyGenerator");
        this.puta("KeyGenerator.PKCS#12-IV", "iaik.pkcs.pkcs12.IvGenerator");
        this.puta("KeyGenerator.PKCS#12-MAC", "iaik.pkcs.pkcs12.MacKeyGenerator");
        this.puta("KeyGenerator.PBKDF2", "iaik.pkcs.pkcs5.PBKDF2");
        this.puta("KeyFactory.DSA", "iaik.security.dsa.DSAKeyFactory");
        this.puta("Alg.Alias.KeyFactory.1.3.14.3.2.12", "DSA");
        this.puta("Alg.Alias.KeyFactory.1.2.840.10040.4.1", "DSA");
        this.puta("Alg.Alias.KeyFactory.1.3.14.3.2.13", "DSA");
        this.puta("Alg.Alias.KeyFactory.1.3.14.3.2.27", "DSA");
        this.puta("Alg.Alias.KeyFactory.1.2.840.10040.4.3", "DSA");
        this.puta("KeyFactory.DH", "iaik.security.dh.DHKeyFactory");
        this.puta("Alg.Alias.KeyFactory.DiffieHellman", "DH");
        this.puta("KeyFactory.ESDH", "iaik.security.dh.ESDHKeyFactory");
        this.puta("Alg.Alias.KeyFactory.ESDiffieHellman", "ESDH");
        this.puta("Alg.Alias.KeyFactory.1.2.840.10046.2.1", "ESDH");
        this.puta("SecretKeyFactory.PBE", "iaik.pkcs.pkcs5.KeyFactory");
        this.puta("Alg.Alias.SecretKeyFactory.PKCS#5", "PBE");
        this.puta("SecretKeyFactory.PKCS#12", "iaik.pkcs.pkcs12.KeyFactory");
        this.puta("KeyStore.KeyStore", "iaik.security.keystore.IAIKKeyStore");
        this.puta("Alg.Alias.KeyStore.IAIKKeyStore", "KeyStore");
        this.puta("KeyStore.NewKeyStore", "iaik.security.keystore.NewKeyStore");
        this.puta("KeyAgreement.DH", "iaik.security.dh.DHKeyAgreement");
        this.puta("Alg.Alias.KeyAgreement.DiffieHellman", "DH");
        this.puta("Alg.Alias.KeyAgreement.1.2.840.113549.1.3.1", "DH");
        this.puta("KeyAgreement.ESDH", "iaik.security.dh.ESDHKeyAgreement");
        this.puta("Alg.Alias.KeyAgreement.ESDiffieHellman", "ESDH");
        this.puta("Alg.Alias.KeyAgreement.1.2.840.113549.1.9.16.3.5", "ESDH");
        this.puta("AlgorithmParameterGenerator.DH", "iaik.security.dh.DHParameterGenerator");
        this.puta("Alg.Alias.AlgorithmParameterGenerator.DiffieHellman", "DH");
        this.puta("AlgorithmParameterGenerator.ESDH", "iaik.security.dh.ESDHParameterGenerator");
        this.puta("Alg.Alias.AlgorithmParameterGenerator.ESDiffieHellman", "ESDH");
        this.puta("AlgorithmParameterGenerator.PBE", "iaik.security.pbe.PBEParameterGenerator");
        this.puta("AlgorithmParameters.DSA", "iaik.security.dsa.DSAParameters");
        this.puta("AlgorithmParameters.DH", "iaik.security.dh.DHParameters");
        this.puta("Alg.Alias.AlgorithmParameters.DiffieHellman", "DH");
        this.puta("AlgorithmParameters.ESDH", "iaik.security.dh.ESDHParameters");
        this.puta("Alg.Alias.AlgorithmParameters.ESDiffieHellman", "ESDH");
        this.puta("AlgorithmParameters.ESDHKEK", "iaik.security.dh.ESDHKEKParameters");
        this.puta("AlgorithmParameters.PBE", "iaik.security.pbe.PBEParameters");
        this.puta("Mac.HMAC/MD5", "iaik.security.mac.HMacMd5");
        this.puta("Alg.Alias.Mac.HmacMD5", "HMAC/MD5");
        this.puta("Alg.Alias.Mac.1.3.6.1.5.5.8.1.1", "HMAC/MD5");
        this.puta("Mac.HMAC/SHA", "iaik.security.mac.HMacSha");
        this.puta("Alg.Alias.Mac.HmacSHA1", "HMAC/SHA");
        this.puta("Alg.Alias.Mac.HMAC/SHA-1", "HMAC/SHA");
        this.puta("Alg.Alias.Mac.1.3.6.1.5.5.8.1.2", "HMAC/SHA");
        this.puta("Alg.Alias.Mac.1.2.840.113549.2.7", "HMAC/SHA");
        this.puta("Mac.HMAC/SHA256", "iaik.security.mac.HMacSha256");
        this.puta("Alg.Alias.Mac.HmacSHA256", "HMAC/SHA256");
        this.puta("Alg.Alias.Mac.HMAC/SHA-256", "HMAC/SHA256");
        this.puta("Mac.HMAC/SHA384", "iaik.security.mac.HMacSha384");
        this.puta("Alg.Alias.Mac.HmacSHA384", "HMAC/SHA384");
        this.puta("Alg.Alias.Mac.HMAC/SHA-384", "HMAC/SHA384");
        this.puta("Mac.HMAC/SHA512", "iaik.security.mac.HMacSha512");
        this.puta("Alg.Alias.Mac.HmacSHA512", "HMAC/SHA512");
        this.puta("Alg.Alias.Mac.HMAC/SHA-512", "HMAC/SHA512");
        this.puta("Mac.HMAC/RIPEMD128", "iaik.security.mac.HMacRipeMd128");
        this.puta("Alg.Alias.Mac.HMAC/RipeMd128", "HMAC/RIPEMD128");
        this.puta("Alg.Alias.Mac.HMAC/RIPEMD-128", "HMAC/RIPEMD128");
        this.puta("Alg.Alias.Mac.HmacRipeMd128", "HMAC/RIPEMD128");
        this.puta("Mac.HMAC/RIPEMD160", "iaik.security.mac.HMacRipeMd160");
        this.puta("Alg.Alias.Mac.HMAC/RipeMd160", "HMAC/RIPEMD160");
        this.puta("Alg.Alias.Mac.HMAC/RIPEMD-160", "HMAC/RIPEMD160");
        this.puta("Alg.Alias.Mac.HmacRipeMd160", "HMAC/RIPEMD160");
        this.puta("Alg.Alias.Mac.1.3.6.1.5.5.8.1.4", "HMAC/RIPEMD160");
        this.puta("CertificateFactory.X.509", "iaik.x509.CertificateFactory");
        this.puta("Alg.Alias.CertificateFactory.X509", "X.509");
        this.puta("CertificateFactory.Qualified", "iaik.x509.qualified.QualifiedCertificateFactory");
    }

    public static void addAsProvider() {
        IAIK.addAsProvider(false);
    }

    public static IAIK getInstance() {
        if (instance == null) {
            new IAIK();
        }
        return instance;
    }

    public static void addAsProvider(boolean printStatusInfo) {
        IAIK.addAsProvider(printStatusInfo, false);
    }

    public static void addAsJDK14Provider(boolean printStatusInfo) {
        IAIK.addAsProvider(printStatusInfo, true);
    }

    public static void addAsJDK14Provider() {
        IAIK.addAsJDK14Provider(false);
    }

    private static void addAsProvider(boolean printStatusInfo, boolean forJDK14) {
        IAIK iaik = new IAIK();
        if (forJDK14) {
            iaik.remove("MessageDigest.MD5");
            iaik.remove("MessageDigest.SHA-1");
            iaik.remove("CertificateFactory.X.509");
        }
        Security.insertProviderAt(iaik, 1);
        if (forJDK14) {
            try {
                Cipher.getInstance("DES/CBC/PKCS5Padding", "IAIK");
            }
            catch (Exception exception) {
                // empty catch block
            }
            iaik.putc("MessageDigest.MD5", "iaik.security.md.Md5Old", useOldMd5);
            iaik.putc("MessageDigest.MD5", "iaik.security.md.Md5", !useOldMd5);
            iaik.put("MessageDigest.SHA-1", "iaik.security.md.SHA");
            iaik.put("CertificateFactory.X.509", "iaik.x509.CertificateFactory");
        }
        if (printStatusInfo) {
            System.out.println("adding Provider IAIK...\n");
            Properties props = System.getProperties();
            System.out.println("Java version number: " + ((Hashtable)props).get("java.version"));
            System.out.println("Java compiler: " + ((Hashtable)props).get("java.compiler"));
            System.out.println("Java vendor-specific string: " + ((Hashtable)props).get("java.vendor"));
            System.out.println("Java vendor URL: " + ((Hashtable)props).get("java.vendor.url"));
            System.out.println("Java installation directory: " + ((Hashtable)props).get("java.home"));
            System.out.println("Java class format version number: " + ((Hashtable)props).get("java.class.version"));
            System.out.println("Java class path: " + ((Hashtable)props).get("java.class.path"));
            System.out.println("Operating system name: " + ((Hashtable)props).get("os.name"));
            System.out.println("Operating system architecture: " + ((Hashtable)props).get("os.arch"));
            System.out.println("Operating system version: " + ((Hashtable)props).get("os.version"));
            System.out.println();
            System.out.println("Installed security providers providers:\n");
            Provider[] providers = Security.getProviders();
            int i = 0;
            while (i < providers.length) {
                Provider provider = providers[i];
                System.out.println("Provider " + (i + 1) + ": " + provider.getName() + "  version: " + provider.getVersion());
                ++i;
            }
        }
    }

    public static void setUseOldMd5(boolean useOldMd5) {
        IAIK.useOldMd5 = useOldMd5;
    }

    public static boolean getUseOldMd5() {
        return useOldMd5;
    }

    public static MessageDigest getMd5() {
        if (useOldMd5) {
            return new Md5Old();
        }
        return new Md5();
    }
}

