/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.dh;

import iaik.security.md.SHA;
import iaik.security.random.SecRandom;
import iaik.utils.NumberTheory;
import java.math.BigInteger;
import java.security.AlgorithmParameterGeneratorSpi;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.spec.DHGenParameterSpec;
import javax.crypto.spec.DHParameterSpec;

public class DHParameterGenerator
extends AlgorithmParameterGeneratorSpi {
    private int c = 300;
    private int b = 1024;
    private SecureRandom a;
    private static final BigInteger e;
    private static final BigInteger f;
    private static final BigInteger d;
    private static final int h = 300;
    private static final int g = 1024;
    private static final boolean i = false;

    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        this.a = secureRandom;
        if (algorithmParameterSpec instanceof DHGenParameterSpec) {
            this.b = ((DHGenParameterSpec)algorithmParameterSpec).getPrimeSize();
            this.c = ((DHGenParameterSpec)algorithmParameterSpec).getExponentSize();
            if (this.c > this.b) {
                throw new InvalidAlgorithmParameterException("The size of the exponent must be less than the size of the modulus");
            }
        } else {
            throw new InvalidAlgorithmParameterException("Parameter must be a DHGenParameterSpec.");
        }
        this.a();
    }

    protected void engineInit(int n, SecureRandom secureRandom) {
        this.a = secureRandom;
        this.b = n;
        this.c = 0;
        this.a();
    }

    protected AlgorithmParameters engineGenerateParameters() {
        Object object;
        BigInteger bigInteger;
        Object object2;
        Object object3;
        BigInteger bigInteger2;
        BigInteger bigInteger3;
        int n;
        block14: {
            byte[] byArray;
            Object object4;
            Object object5;
            if (this.a == null) {
                this.a = SecRandom.getDefault();
            }
            n = this.b;
            int n2 = this.c;
            if (n2 <= 0) {
                n2 = 300;
            }
            int n3 = (n2 + 159) / 160;
            int n4 = (n + 159) / 160;
            int n5 = (n + 1023) / 1024;
            BigInteger bigInteger4 = e.pow(n2);
            BigInteger bigInteger5 = e.pow(n);
            BigInteger bigInteger6 = e.pow(n - 1);
            byte[] byArray2 = new byte[(n2 + 7) / 8];
            SHA sHA = new SHA();
            byte[] byArray3 = new byte[20 * n3];
            do {
                this.a.nextBytes(byArray2);
                byte[] byArray4 = (byte[])byArray2.clone();
                object5 = (byte[])byArray2.clone();
                int n6 = 0;
                while (n6 < n3) {
                    DHParameterGenerator.a((byte[])object5);
                    ++n6;
                }
                int n7 = 0;
                while (n7 < n3) {
                    object4 = sHA.digest(byArray4);
                    byArray = sHA.digest((byte[])object5);
                    DHParameterGenerator.a(byArray4);
                    DHParameterGenerator.a((byte[])object5);
                    int n8 = 0;
                    int n9 = n7 * 20;
                    while (n8 < 20) {
                        byArray3[n9] = (byte)(object4[n8] ^ byArray[n8]);
                        ++n8;
                        ++n9;
                    }
                    ++n7;
                }
                bigInteger3 = new BigInteger(1, byArray3);
                bigInteger3 = bigInteger3.mod(bigInteger4);
                bigInteger3 = bigInteger3.setBit(0);
            } while (!NumberTheory.isProbablePrime(bigInteger3 = bigInteger3.setBit(n2 - 1)));
            int n10 = 0;
            object5 = new BigInteger(1, byArray2);
            BigInteger bigInteger7 = BigInteger.valueOf(n3);
            bigInteger7 = bigInteger7.add(bigInteger7);
            BigInteger bigInteger8 = BigInteger.valueOf(n4);
            object4 = d;
            byArray = new byte[20 * n4];
            do {
                bigInteger2 = ((BigInteger)object5).add(bigInteger7).add((BigInteger)object4);
                object3 = bigInteger2.toByteArray();
                int n11 = 0;
                while (n11 < n4) {
                    object2 = sHA.digest((byte[])object3);
                    DHParameterGenerator.a(object3);
                    int n12 = 0;
                    int n13 = n11 * 20;
                    while (n12 < 20) {
                        byArray[n13] = (byte)object2[n12];
                        ++n12;
                        ++n13;
                    }
                    ++n11;
                }
                object2 = new BigInteger(1, byArray).mod(bigInteger5);
                BigInteger bigInteger9 = ((BigInteger)object2).setBit(n - 1);
                bigInteger = bigInteger9.subtract(bigInteger9.mod(bigInteger3.add(bigInteger3))).add(f);
                if (bigInteger.compareTo(bigInteger6) > 0 && NumberTheory.isProbablePrime(bigInteger)) break block14;
                object4 = ((BigInteger)object4).add(bigInteger8);
            } while (++n10 < 4096 * n5);
            throw new RuntimeException("Parameter generation failed!");
        }
        object3 = bigInteger.subtract(f).divide(bigInteger3);
        while ((bigInteger2 = ((BigInteger)(object = new BigInteger(n + 4, this.a).mod(bigInteger.subtract(f)).add(f))).modPow((BigInteger)object3, bigInteger)).compareTo(f) == 0) {
        }
        object = this.c < 0 ? new DHParameterSpec(bigInteger, bigInteger2) : new DHParameterSpec(bigInteger, bigInteger2, this.c);
        try {
            object2 = AlgorithmParameters.getInstance("DH", "IAIK");
            ((AlgorithmParameters)object2).init((AlgorithmParameterSpec)object);
            return object2;
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new RuntimeException(invalidParameterSpecException.toString());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException(noSuchAlgorithmException.toString());
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new RuntimeException(noSuchProviderException.toString());
        }
    }

    private void a() throws IllegalArgumentException {
        if (this.b < 512 || this.c != 0 && this.c < 160) {
            throw new IllegalArgumentException("Prime must be at least 512, exponent at least 160 bits long!");
        }
    }

    private static void a(byte[] byArray) {
        int n = byArray.length;
        while (n > 0) {
            int n2 = --n;
            byArray[n2] = (byte)(byArray[n2] + 1);
            byte by = byArray[n2];
            if (by == 0) continue;
            return;
        }
    }

    static {
        d = BigInteger.valueOf(0L);
        f = BigInteger.valueOf(1L);
        e = BigInteger.valueOf(2L);
    }
}

