/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs7;

import iaik.asn1.ASN1Object;
import iaik.asn1.DerCoder;
import iaik.asn1.OCTET_STRING;
import iaik.pkcs.PKCSException;
import iaik.pkcs.PKCSParsingException;
import iaik.pkcs.pkcs7.Content;
import iaik.pkcs.pkcs7.DataStream;
import iaik.utils.StreamCopier;
import iaik.utils.Util;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class Data
extends DataStream
implements Content {
    byte[] a;

    public String toString(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("PKCS#7 Data: ");
        if (this.a != null) {
            stringBuffer.append(String.valueOf(this.a.length) + " bytes");
            if (bl) {
                stringBuffer.append(": " + Util.toString(this.a, 0, 15));
                if (this.a.length > 15) {
                    stringBuffer.append("...");
                }
            }
        } else {
            stringBuffer.append("No content!");
        }
        return stringBuffer.toString();
    }

    public ASN1Object toASN1Object() throws PKCSException {
        if (this.b > 0) {
            return new OCTET_STRING(this.a, this.b);
        }
        return new OCTET_STRING(this.a);
    }

    public InputStream getInputStream() {
        if (this.a != null) {
            return new ByteArrayInputStream(this.a);
        }
        return ((DataStream)this).a;
    }

    public byte[] getEncoded() throws PKCSException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DerCoder.encodeTo(this.toASN1Object(), byteArrayOutputStream);
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new PKCSException(iOException.getMessage());
        }
    }

    public byte[] getData() {
        return this.a;
    }

    public void decode(InputStream inputStream) throws PKCSParsingException, IOException {
        super.decode(inputStream);
        if (((DataStream)this).a != null) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            StreamCopier streamCopier = new StreamCopier(((DataStream)this).a, byteArrayOutputStream);
            streamCopier.copyStream();
            this.a = byteArrayOutputStream.toByteArray();
        }
    }

    public void decode(ASN1Object aSN1Object) throws PKCSParsingException {
        if (aSN1Object == null) {
            throw new PKCSParsingException("Cannot decode a null object!");
        }
        byte[] byArray = DerCoder.encode(aSN1Object);
        if (byArray == null) {
            throw new PKCSParsingException("Parsing error!");
        }
        try {
            this.decode(new ByteArrayInputStream(byArray));
            return;
        }
        catch (IOException iOException) {
            throw new PKCSParsingException(iOException.getMessage());
        }
    }

    public Data(byte[] byArray, int n) {
        this();
        this.a = byArray;
        this.b = n;
    }

    public Data(byte[] byArray) {
        this();
        this.a = byArray;
    }

    public Data(InputStream inputStream) throws PKCSParsingException, IOException {
        this();
        this.decode(inputStream);
    }

    public Data(ASN1Object aSN1Object) throws PKCSParsingException {
        this();
        this.decode(aSN1Object);
    }

    protected Data() {
    }
}

