/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs12;

import iaik.asn1.ASN1Object;
import iaik.asn1.ASN1Type;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.ObjectID;
import iaik.asn1.structures.AlgorithmID;
import iaik.pkcs.PKCSException;
import iaik.pkcs.PKCSParsingException;
import iaik.pkcs.pkcs12.PKCS8ShroudedKeyBag;
import iaik.pkcs.pkcs12.SafeBag;
import iaik.pkcs.pkcs7.Content;
import iaik.pkcs.pkcs7.ContentInfo;
import iaik.pkcs.pkcs7.Data;
import iaik.pkcs.pkcs7.EncryptedContentInfo;
import iaik.pkcs.pkcs7.EncryptedData;
import iaik.pkcs.pkcs7.EncryptedDataStream;
import iaik.security.cipher.PBEKeyBMP;
import iaik.utils.InternalErrorException;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;

public class AuthenticatedSafe
implements ASN1Type {
    static /* synthetic */ Class g;
    private static final int h = 1024;
    SafeBag[] a;
    private int b;
    private ContentInfo d;
    EncryptedContentInfo c;
    public static final int PUBLIC_KEY_ENCRYPTED = 3;
    public static final int PASSWORD_ENCRYPTED = 2;
    public static final int UNENCRYPTED = 1;
    private static final boolean e = false;
    private static final boolean f = false;

    static Class a(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("mode: ");
        switch (this.b) {
            case 1: {
                stringBuffer.append("UNENCRYPTED\n");
                break;
            }
            case 2: {
                stringBuffer.append("PASSWORD_ENCRYPTED\n");
                stringBuffer.append("Content encrypted with: " + this.c.getContentEncryptionAlgorithm().getName() + "\n");
                break;
            }
            case 3: {
                stringBuffer.append("PUBLIC_KEY_ENCRYPTED\n");
                break;
            }
        }
        if (this.a == null) {
            stringBuffer.append("No SafeBags or not decrypted yet.\n");
        } else {
            int n = 0;
            while (n < this.a.length) {
                stringBuffer.append("\nSafeBag: " + n + "\n");
                stringBuffer.append(this.a[n].toString());
                ++n;
            }
        }
        return stringBuffer.toString();
    }

    public ASN1Object toASN1Object() throws CodingException {
        try {
            return this.d.toASN1Object();
        }
        catch (PKCSException pKCSException) {
            throw new CodingException(pKCSException.toString());
        }
    }

    public SafeBag[] getSafeBags() {
        return this.a;
    }

    public void encrypt(char[] cArray, AlgorithmID algorithmID) throws PKCSException, NoSuchAlgorithmException {
        switch (this.b) {
            case 2: {
                Object object;
                AlgorithmParameterSpec algorithmParameterSpec = null;
                if (algorithmID.equals(AlgorithmID.pbeWithSHAAnd40BitRC2_CBC) || algorithmID.equals(AlgorithmID.pbeWithSHAAnd3_KeyTripleDES_CBC)) {
                    try {
                        object = algorithmID.getAlgorithmParameters("PBE");
                        algorithmParameterSpec = (AlgorithmParameterSpec)((AlgorithmParameters)object).getParameterSpec(g != null ? g : (g = AuthenticatedSafe.a("javax.crypto.spec.PBEParameterSpec")));
                    }
                    catch (Exception exception) {
                        throw new InternalErrorException(exception);
                    }
                } else {
                    throw new NoSuchAlgorithmException(String.valueOf(algorithmID.getName()) + " not allowed!");
                }
                try {
                    this.c.setupCipher(algorithmID, new PBEKeyBMP(cArray), algorithmParameterSpec);
                }
                catch (KeyException keyException) {
                    throw new PKCSException(keyException.toString());
                }
                catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                    throw new PKCSException(invalidAlgorithmParameterException.toString());
                }
                object = new EncryptedData(this.c);
                ((EncryptedDataStream)object).setBlockSize(1024);
                this.d = new ContentInfo((Content)object);
                return;
            }
            case 3: {
                throw new RuntimeException("PUBLIC_KEY_ENCRYPTED not implemented");
            }
            default: {
                throw new PKCSException("Unknown mode!");
            }
            case 1: 
        }
    }

    public void decrypt(char[] cArray) throws NoSuchAlgorithmException, PKCSException {
        switch (this.b) {
            case 2: {
                try {
                    AlgorithmID algorithmID = this.c.getContentEncryptionAlgorithm();
                    AlgorithmParameters algorithmParameters = algorithmID.getAlgorithmParameters("PBE");
                    Object t = algorithmParameters.getParameterSpec(g != null ? g : (g = AuthenticatedSafe.a("javax.crypto.spec.PBEParameterSpec")));
                    this.c.setupCipher(new PBEKeyBMP(cArray), (AlgorithmParameterSpec)t);
                    byte[] byArray = this.c.getContent();
                    ASN1Object aSN1Object = DerCoder.decode(byArray);
                    this.a = SafeBag.parseSafeContents(DerCoder.encode(aSN1Object));
                    break;
                }
                catch (Exception exception) {
                    throw new PKCSException(exception.toString());
                }
            }
            case 3: {
                throw new PKCSException("privacy mode PUBLIC_KEY_ENCRYPTED not implemented.");
            }
            default: {
                throw new PKCSException("Unknown authenticated safes mode.");
            }
            case 1: 
        }
        if (this.a != null) {
            int n = 0;
            while (n < this.a.length) {
                if (this.a[n] instanceof PKCS8ShroudedKeyBag) {
                    try {
                        ((PKCS8ShroudedKeyBag)this.a[n]).decrypt(cArray);
                    }
                    catch (GeneralSecurityException generalSecurityException) {
                        throw new PKCSException("Unable to decrypt PrivateKey!");
                    }
                }
                ++n;
            }
        }
    }

    public void decode(ASN1Object aSN1Object) throws CodingException {
        try {
            this.d = new ContentInfo(aSN1Object);
        }
        catch (PKCSParsingException pKCSParsingException) {
            throw new CodingException(pKCSParsingException.toString());
        }
        if (this.d.getContentType().equals(ObjectID.pkcs7_encryptedData)) {
            this.b = 2;
            EncryptedData encryptedData = (EncryptedData)this.d.getContent();
            this.c = (EncryptedContentInfo)encryptedData.getEncryptedContentInfo();
            return;
        }
        if (this.d.getContentType().equals(ObjectID.pkcs7_envelopedData)) {
            this.b = 3;
            throw new CodingException("public-key encrypted not implemented.");
        }
        if (this.d.getContentType().equals(ObjectID.pkcs7_data)) {
            this.b = 1;
            byte[] byArray = ((Data)this.d.getContent()).getData();
            this.a = SafeBag.parseSafeContents(byArray);
            return;
        }
        throw new CodingException("Unknown content type in AuthenticatedSafes.");
    }

    public AuthenticatedSafe(ASN1Object aSN1Object) throws PKCSParsingException {
        try {
            this.decode(aSN1Object);
            return;
        }
        catch (CodingException codingException) {
            throw new PKCSParsingException(codingException.toString());
        }
    }

    public AuthenticatedSafe(int n, SafeBag[] safeBagArray) throws PKCSException {
        this.b = n;
        this.a = safeBagArray;
        try {
            byte[] byArray = SafeBag.encodeSafeContents(this.a);
            if (n == 2) {
                this.c = new EncryptedContentInfo(ObjectID.pkcs7_data, byArray);
                this.c.setBlockSize(1024);
                return;
            }
            if (n == 3) {
                throw new RuntimeException("PUBLIC_KEY_ENCRYPTED not implemented");
            }
            if (n == 1) {
                Data data = new Data(byArray);
                data.setBlockSize(1024);
                this.d = new ContentInfo(data);
                return;
            }
            throw new PKCSException("Unknown mode!");
        }
        catch (CodingException codingException) {
            throw new PKCSException("Unknown mode!");
        }
    }
}

