/*
 * Decompiled with CFR 0.152.
 */
package iaik.asn1.structures;

import iaik.asn1.ASN1Object;
import iaik.asn1.ASN1Type;
import iaik.asn1.CodingException;
import iaik.asn1.ObjectID;
import iaik.asn1.SET;
import iaik.asn1.structures.AVA;
import iaik.utils.RFC2253NameParserException;
import java.util.Enumeration;
import java.util.Vector;

public class RDN
implements ASN1Type {
    protected Vector avas = new Vector(3);

    /*
     * Enabled aggressive block sorting
     */
    public String toString(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.avas.elements();
        if (!enumeration.hasMoreElements()) {
            return stringBuffer.toString();
        }
        stringBuffer.append(((AVA)enumeration.nextElement()).toString(bl));
        while (enumeration.hasMoreElements()) {
            stringBuffer.append("+" + ((AVA)enumeration.nextElement()).toString(bl));
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return this.toString(false);
    }

    public ASN1Object toASN1Object() {
        SET sET = new SET();
        Enumeration enumeration = this.avas.elements();
        while (enumeration.hasMoreElements()) {
            sET.addComponent(((AVA)enumeration.nextElement()).toASN1Object());
        }
        return sET;
    }

    public int hashCode() {
        int n;
        int n2 = n = this.avas.size();
        Enumeration enumeration = this.avas.elements();
        while (enumeration.hasMoreElements()) {
            AVA aVA = (AVA)enumeration.nextElement();
            n2 = n2 << 7 | n2 >>> 25;
            n2 += aVA.hashCode();
        }
        return n2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public String getRFC2253String() throws RFC2253NameParserException {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.avas.elements();
        if (!enumeration.hasMoreElements()) {
            return stringBuffer.toString();
        }
        stringBuffer.append(((AVA)enumeration.nextElement()).getRFC2253String());
        while (enumeration.hasMoreElements()) {
            stringBuffer.append("+" + ((AVA)enumeration.nextElement()).getRFC2253String());
        }
        return stringBuffer.toString();
    }

    public AVA getAVA(ObjectID objectID) {
        Enumeration enumeration = this.avas.elements();
        while (enumeration.hasMoreElements()) {
            AVA aVA = (AVA)enumeration.nextElement();
            if (!aVA.getType().equals(objectID)) continue;
            return aVA;
        }
        return null;
    }

    public AVA getAVA() {
        return (AVA)this.avas.elementAt(0);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof RDN)) {
            return false;
        }
        RDN rDN = (RDN)object;
        int n = this.avas.size();
        if (n != rDN.avas.size()) {
            return false;
        }
        int n2 = 0;
        while (n2 < n) {
            AVA aVA;
            AVA aVA2 = (AVA)this.avas.elementAt(n2);
            if (!aVA2.equals(aVA = (AVA)rDN.avas.elementAt(n2))) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public Enumeration elements() {
        return this.avas.elements();
    }

    public void decode(ASN1Object aSN1Object) throws CodingException {
        int n = 0;
        while (n < aSN1Object.countComponents()) {
            AVA aVA = new AVA(aSN1Object.getComponentAt(n));
            this.addAVA(aVA);
            ++n;
        }
    }

    public void addAVA(AVA aVA) {
        ObjectID objectID = aVA.getType();
        int n = this.avas.size();
        int n2 = 0;
        while (n2 < n) {
            AVA aVA2 = (AVA)this.avas.elementAt(n2);
            if (aVA2.getType().equals(objectID)) {
                this.avas.setElementAt(aVA, n2);
                return;
            }
            ++n2;
        }
        this.avas.addElement(aVA);
    }

    public void addAVA(ObjectID objectID, Object object) {
        this.addAVA(new AVA(objectID, object));
    }

    public RDN(ObjectID objectID, Object object) {
        this();
        this.addAVA(objectID, object);
    }

    public RDN(ASN1Object aSN1Object) throws CodingException {
        this();
        this.decode(aSN1Object);
    }

    public RDN() {
    }
}

