/*
 * Decompiled with CFR 0.152.
 */
package iaik.asn1.structures;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.ASN1Type;
import iaik.asn1.CON_SPEC;
import iaik.asn1.CodingException;
import iaik.asn1.INTEGER;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.GeneralName;
import java.math.BigInteger;

public class GeneralSubtree
implements ASN1Type {
    int b = -1;
    int a;
    GeneralName c;

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("base: " + this.c + "\n");
        stringBuffer.append("minimum: " + this.a + "\n");
        if (this.b != -1) {
            stringBuffer.append("maximum: " + this.b + "\n");
        }
        stringBuffer.setLength(stringBuffer.length() - 1);
        return stringBuffer.toString();
    }

    public ASN1Object toASN1Object() throws CodingException {
        boolean bl = true;
        SEQUENCE sEQUENCE = new SEQUENCE();
        sEQUENCE.addComponent(this.c.toASN1Object());
        if (this.a != 0) {
            sEQUENCE.addComponent(new CON_SPEC(0, new INTEGER(this.a), bl));
        }
        if (this.b != -1) {
            sEQUENCE.addComponent(new CON_SPEC(1, new INTEGER(this.b), bl));
        }
        return sEQUENCE;
    }

    public void setMinimum(int n) {
        this.a = n;
    }

    public void setMaximum(int n) {
        this.b = n;
    }

    public int getMinimum() {
        return this.a;
    }

    public int getMaximum() {
        return this.b;
    }

    public GeneralName getBase() {
        return this.c;
    }

    public void decode(ASN1Object aSN1Object) throws CodingException {
        try {
            this.c = new GeneralName(aSN1Object.getComponentAt(0));
            int n = 1;
            while (n < aSN1Object.countComponents()) {
                CON_SPEC cON_SPEC = (CON_SPEC)aSN1Object.getComponentAt(n);
                switch (cON_SPEC.getAsnType().getTag()) {
                    case 0: {
                        if (cON_SPEC.isImplicitlyTagged()) {
                            cON_SPEC.forceImplicitlyTagged(ASN.INTEGER);
                        }
                        this.a = ((BigInteger)((ASN1Object)cON_SPEC.getValue()).getValue()).intValue();
                        break;
                    }
                    case 1: {
                        if (cON_SPEC.isImplicitlyTagged()) {
                            cON_SPEC.forceImplicitlyTagged(ASN.INTEGER);
                        }
                        this.b = ((BigInteger)((ASN1Object)cON_SPEC.getValue()).getValue()).intValue();
                        break;
                    }
                }
                ++n;
            }
            return;
        }
        catch (Exception exception) {
            throw new CodingException(exception.getMessage());
        }
    }

    public GeneralSubtree(GeneralName generalName) {
        this.c = generalName;
    }

    public GeneralSubtree() {
    }
}

