/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.jsse.utils;

import com.sun.net.ssl.KeyManager;
import com.sun.net.ssl.KeyManagerFactory;
import com.sun.net.ssl.TrustManager;
import com.sun.net.ssl.TrustManagerFactory;
import com.sun.net.ssl.X509KeyManager;
import com.sun.net.ssl.X509TrustManager;
import iaik.security.jsse.utils.Debug;
import iaik.security.ssl.CipherSuiteList;
import java.io.File;
import java.io.FileInputStream;
import java.security.KeyStore;
import java.security.cert.X509Certificate;

public class Util {
    protected static CipherSuiteList CIPHER_SUITES = new CipherSuiteList(3);
    public static final String DEFAULT_TRUST_STORE_PASSWORD = "javax.net.ssl.trustStorePassword";
    public static final String DEFAULT_TRUST_STORE_TYPE = "javax.net.ssl.trustStoreType";
    public static final String DEFAULT_TRUST_STORE = "javax.net.ssl.trustStore";
    public static final String DEFAULT_KEY_STORE_PASSWORD = "javax.net.ssl.keyStorePassword";
    public static final String DEFAULT_KEY_STORE_TYPE = "javax.net.ssl.keyStoreType";
    public static final String DEFAULT_KEY_STORE = "javax.net.ssl.keyStore";

    public static X509Certificate recode(javax.security.cert.X509Certificate x509Certificate) {
        try {
            byte[] byArray = x509Certificate.getEncoded();
            iaik.x509.X509Certificate x509Certificate2 = new iaik.x509.X509Certificate(byArray);
            return x509Certificate2;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static javax.security.cert.X509Certificate recode(X509Certificate x509Certificate) {
        try {
            javax.security.cert.X509Certificate x509Certificate2 = javax.security.cert.X509Certificate.getInstance(((iaik.x509.X509Certificate)x509Certificate).toByteArray());
            return x509Certificate2;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static X509TrustManager a(KeyStore keyStore) throws Exception {
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance((String)"SunX509");
        trustManagerFactory.init(keyStore);
        TrustManager[] trustManagerArray = trustManagerFactory.getTrustManagers();
        int n = 0;
        while (n < trustManagerArray.length) {
            if (trustManagerArray[n] instanceof X509TrustManager) {
                Debug debug = Debug.getInstance();
                debug.println("Found X509 TrustManager");
                return (X509TrustManager)trustManagerArray[n];
            }
            ++n;
        }
        return null;
    }

    public static X509TrustManager getDefaultTrustManager() {
        Debug debug = Debug.getInstance();
        KeyStore keyStore = null;
        String string = System.getProperty(DEFAULT_TRUST_STORE);
        String string2 = System.getProperty(DEFAULT_TRUST_STORE_TYPE);
        String string3 = System.getProperty(DEFAULT_TRUST_STORE_PASSWORD);
        try {
            keyStore = string2 != null ? KeyStore.getInstance(System.getProperty(DEFAULT_TRUST_STORE_TYPE)) : KeyStore.getInstance(KeyStore.getDefaultType());
            if (string3 == null) {
                string3 = "";
            }
            if (string != null) {
                debug.println("Using Truststore :" + string);
                if (Util.a(keyStore, string, string3)) {
                    return Util.a(keyStore);
                }
                debug.println("Failed -> using null");
                return null;
            }
            String string4 = System.getProperty("java.home");
            if (Util.a(keyStore, String.valueOf(string4) + "/lib/security/jssecacerts", string3)) {
                return Util.a(keyStore);
            }
            if (Util.a(keyStore, String.valueOf(string4) + "/lib/security/cacerts", string3)) {
                return Util.a(keyStore);
            }
        }
        catch (Exception exception) {
            debug.println(exception.getMessage());
            return null;
        }
        return null;
    }

    public static X509KeyManager getDefaultKeyManager() {
        Debug debug = Debug.getInstance();
        try {
            KeyStore keyStore = KeyStore.getInstance(System.getProperty(DEFAULT_KEY_STORE_TYPE));
            keyStore.load(new FileInputStream(System.getProperty(DEFAULT_KEY_STORE)), System.getProperty(DEFAULT_KEY_STORE_PASSWORD).toCharArray());
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance((String)"SunX509");
            keyManagerFactory.init(keyStore, System.getProperty(DEFAULT_KEY_STORE_PASSWORD).toCharArray());
            KeyManager[] keyManagerArray = keyManagerFactory.getKeyManagers();
            int n = 0;
            while (n < keyManagerArray.length) {
                if (keyManagerArray[n] instanceof X509KeyManager) {
                    return (X509KeyManager)keyManagerArray[n];
                }
                ++n;
            }
        }
        catch (Exception exception) {
            debug.println("Could not load default keystore");
            debug.println(exception.getMessage());
        }
        return null;
    }

    public static CipherSuiteList fromStringArray(String[] stringArray) {
        CipherSuiteList cipherSuiteList = new CipherSuiteList();
        int n = 0;
        while (n < stringArray.length) {
            int n2 = 0;
            while (n2 < CIPHER_SUITES.size()) {
                if (CIPHER_SUITES.elementAt(n2).toString().equals(stringArray[n])) {
                    cipherSuiteList.add(CIPHER_SUITES.elementAt(n2));
                }
                ++n2;
            }
            ++n;
        }
        return cipherSuiteList;
    }

    public static X509Certificate[] convert(javax.security.cert.X509Certificate[] x509CertificateArray) {
        iaik.x509.X509Certificate[] x509CertificateArray2 = new iaik.x509.X509Certificate[x509CertificateArray.length];
        int n = 0;
        while (n < x509CertificateArray.length) {
            x509CertificateArray2[n] = Util.recode(x509CertificateArray[n]);
            ++n;
        }
        return x509CertificateArray2;
    }

    public static javax.security.cert.X509Certificate[] convert(X509Certificate[] x509CertificateArray) {
        javax.security.cert.X509Certificate[] x509CertificateArray2 = new javax.security.cert.X509Certificate[x509CertificateArray.length];
        int n = 0;
        while (n < x509CertificateArray.length) {
            x509CertificateArray2[n] = Util.recode(x509CertificateArray[n]);
            ++n;
        }
        return x509CertificateArray2;
    }

    private static boolean a(KeyStore keyStore, String string, String string2) {
        Debug debug = Debug.getInstance();
        debug.println("Checking " + string + " for truststore");
        File file = new File(string);
        if (!file.exists()) {
            return false;
        }
        try {
            keyStore.load(new FileInputStream(file), string2.toCharArray());
            return true;
        }
        catch (Exception exception) {
            debug.println("Could not load default trust store");
            debug.println(exception.getMessage());
            return false;
        }
    }
}

