/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.jsse.net;

import com.sun.net.ssl.X509KeyManager;
import iaik.security.jsse.net.JSSEClientContext;
import iaik.security.ssl.KeyAndCert;
import iaik.security.ssl.SSLServerContext;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;

public class JSSEServerContext
extends SSLServerContext {
    protected X509KeyManager keyManager_;

    protected void setJSSEKeyManager(X509KeyManager x509KeyManager) {
        this.keyManager_ = x509KeyManager;
    }

    public KeyAndCert getServerCredentials(int n) {
        PrivateKey privateKey;
        if (this.keyManager_ == null) {
            throw new NullPointerException("Keymanager not set");
        }
        String string = JSSEClientContext.getCertTypeAsString(n);
        String string2 = this.keyManager_.chooseServerAlias(string, null);
        if (string2 == null) {
            throw new NullPointerException("No matching server certificate found");
        }
        X509Certificate[] x509CertificateArray = this.keyManager_.getCertificateChain(string2);
        if (x509CertificateArray != null && (privateKey = this.keyManager_.getPrivateKey(string2)) != null) {
            return new KeyAndCert(x509CertificateArray, privateKey);
        }
        throw new NullPointerException("No matching server certificate found");
    }

    public Object clone() {
        return new JSSEServerContext(this);
    }

    public JSSEServerContext(SecureRandom secureRandom) {
        super(secureRandom);
    }

    public JSSEServerContext(JSSEServerContext jSSEServerContext) {
        super((SSLServerContext)jSSEServerContext);
        this.keyManager_ = jSSEServerContext.keyManager_;
    }

    public JSSEServerContext() {
    }
}

