/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.jsse.net;

import com.sun.net.ssl.X509KeyManager;
import iaik.security.jsse.net.KeyTypeNames;
import iaik.security.ssl.KeyAndCert;
import iaik.security.ssl.SSLClientContext;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;

class JSSEClientContext
extends SSLClientContext
implements KeyTypeNames {
    protected X509KeyManager keyManager_;

    protected void setJSSEKeyManager(X509KeyManager x509KeyManager) {
        this.keyManager_ = x509KeyManager;
    }

    protected KeyAndCert[] getClientCredentials(Principal[] principalArray, byte[] byArray, PublicKey publicKey) {
        if (this.keyManager_ != null) {
            int n = 0;
            while (n < byArray.length) {
                PrivateKey privateKey;
                X509Certificate[] x509CertificateArray;
                String string = JSSEClientContext.getCertTypeAsString(byArray[n]);
                String string2 = this.keyManager_.chooseClientAlias(string, principalArray);
                if (string2 != null && (x509CertificateArray = this.keyManager_.getCertificateChain(string2)) != null && (privateKey = this.keyManager_.getPrivateKey(string2)) != null) {
                    return new KeyAndCert[]{new KeyAndCert(x509CertificateArray, privateKey)};
                }
                ++n;
            }
            return new KeyAndCert[0];
        }
        return new KeyAndCert[0];
    }

    protected static String getCertTypeAsString(int n) {
        switch (n) {
            case 1: {
                return "RSA";
            }
            case 2: {
                return "DSA";
            }
            case 3: {
                return "DH";
            }
            case 4: {
                return "DH";
            }
            case 257: {
                return "RSA";
            }
        }
        return null;
    }

    public Object clone() {
        return new JSSEClientContext(this);
    }

    public JSSEClientContext(SecureRandom secureRandom) {
        super(secureRandom);
    }

    public JSSEClientContext(JSSEClientContext jSSEClientContext) {
        super((SSLClientContext)jSSEClientContext);
        this.keyManager_ = jSSEClientContext.keyManager_;
    }

    public JSSEClientContext() {
    }
}

