/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.jsse.net;

import com.sun.net.ssl.X509TrustManager;
import iaik.security.jsse.utils.Debug;
import iaik.security.ssl.ChainVerifier;
import iaik.security.ssl.SSLTransport;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Vector;

public class JSSEChainVerifier
extends ChainVerifier {
    private Debug b = Debug.getInstance();
    private X509TrustManager a;

    public boolean verifyChain(X509Certificate[] x509CertificateArray, SSLTransport sSLTransport) {
        this.b.println("Verify chain ...");
        if (this.a != null) {
            if (sSLTransport.getUseClientMode()) {
                return this.a.isServerTrusted(x509CertificateArray);
            }
            return this.a.isClientTrusted(x509CertificateArray);
        }
        this.b.println("No TrustManager installed, rejecting connection");
        return false;
    }

    public Principal[] getTrustedPrincipalsArray() {
        if (this.a == null) {
            return new Principal[0];
        }
        X509Certificate[] x509CertificateArray = this.a.getAcceptedIssuers();
        if (x509CertificateArray == null) {
            return new Principal[0];
        }
        Principal[] principalArray = new Principal[x509CertificateArray.length];
        int n = 0;
        while (n < principalArray.length) {
            principalArray[n] = x509CertificateArray[n].getSubjectDN();
            ++n;
        }
        return principalArray;
    }

    public Enumeration getTrustedPrincipals() {
        Vector<Object> vector = this.a != null ? new Vector<X509Certificate>(Arrays.asList(this.a.getAcceptedIssuers())) : new Vector(Collections.EMPTY_LIST);
        return vector.elements();
    }

    public JSSEChainVerifier(X509TrustManager x509TrustManager) {
        this.a = x509TrustManager;
    }
}

