/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.jsse.net;

import com.sun.net.ssl.X509KeyManager;
import com.sun.net.ssl.X509TrustManager;
import iaik.security.jsse.net.IAIKSSLSocketWrapper;
import iaik.security.jsse.net.JSSEChainVerifier;
import iaik.security.jsse.net.JSSEClientContext;
import iaik.security.jsse.net.JSSESessionManager;
import iaik.security.jsse.utils.Debug;
import iaik.security.jsse.utils.Util;
import iaik.security.ssl.CipherSuiteList;
import iaik.security.ssl.SSLContext;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocketFactory;

public class IAIKSSLSocketFactory
extends SSLSocketFactory {
    private X509TrustManager a = null;
    private SecureRandom b = null;
    private X509KeyManager c = null;
    private JSSEClientContext e;
    private static Debug f = Debug.getInstance();

    public void setVersion(int n) {
        switch (n) {
            case 0: {
                this.e.setAllowedProtocolVersions(2, 769);
                break;
            }
            case 1: {
                this.e.setAllowedProtocolVersions(2, 2);
                break;
            }
            case 2: {
                this.e.setAllowedProtocolVersions(768, 768);
                break;
            }
            case 4: {
                this.e.setAllowedProtocolVersions(768, 769);
                break;
            }
            case 3: {
                this.e.setAllowedProtocolVersions(769, 769);
                break;
            }
        }
    }

    private void a(String string) {
        if (this.c == null) {
            return;
        }
        String[] stringArray = this.c.getClientAliases(string, null);
        int n = 0;
        while (n < stringArray.length) {
            X509Certificate[] x509CertificateArray = this.c.getCertificateChain(stringArray[n]);
            PrivateKey privateKey = this.c.getPrivateKey(stringArray[n]);
            this.e.addClientCredentials(x509CertificateArray, privateKey);
            ++n;
        }
    }

    public void setCacheTerminatedSessions(boolean bl) {
        this.e.setCacheTerminatedSessions(bl);
    }

    public String[] getSupportedCipherSuites() {
        CipherSuiteList cipherSuiteList = new CipherSuiteList(3);
        String[] stringArray = new String[cipherSuiteList.size()];
        int n = 0;
        while (n < cipherSuiteList.size()) {
            stringArray[n] = cipherSuiteList.elementAt(n).getName();
            ++n;
        }
        return stringArray;
    }

    public String[] getDefaultCipherSuites() {
        CipherSuiteList cipherSuiteList = this.e.getEnabledCipherSuiteList();
        String[] stringArray = new String[cipherSuiteList.size()];
        int n = 0;
        while (n < cipherSuiteList.size()) {
            stringArray[n] = cipherSuiteList.elementAt(n).getName();
            ++n;
        }
        return stringArray;
    }

    public static synchronized SocketFactory getDefault() {
        return new IAIKSSLSocketFactory(Util.getDefaultTrustManager(), Util.getDefaultKeyManager(), null);
    }

    public Socket createSocket(Socket socket, String string, int n, boolean bl) throws IOException {
        return new IAIKSSLSocketWrapper(socket, string, n, bl, (SSLContext)((JSSEClientContext)this.e.clone()));
    }

    public Socket createSocket(InetAddress inetAddress, int n, InetAddress inetAddress2, int n2) throws IOException {
        return new IAIKSSLSocketWrapper(inetAddress, n, inetAddress2, n2, (SSLContext)((JSSEClientContext)this.e.clone()));
    }

    public Socket createSocket(InetAddress inetAddress, int n) throws IOException {
        return new IAIKSSLSocketWrapper(inetAddress, n, (SSLContext)((JSSEClientContext)this.e.clone()));
    }

    public Socket createSocket(String string, int n, InetAddress inetAddress, int n2) throws IOException {
        return new IAIKSSLSocketWrapper(string, n, inetAddress, n2, (SSLContext)((JSSEClientContext)this.e.clone()));
    }

    public Socket createSocket(String string, int n) throws IOException {
        f.println("Creating Socket " + string + ":" + n);
        return new IAIKSSLSocketWrapper(string, n, (SSLContext)((JSSEClientContext)this.e.clone()));
    }

    public IAIKSSLSocketFactory(X509TrustManager x509TrustManager, X509KeyManager x509KeyManager, SecureRandom secureRandom) {
        f.println("SSLSocketFactory Constructor called");
        this.a = x509TrustManager;
        this.c = x509KeyManager;
        this.b = secureRandom;
        this.e = this.b != null ? new JSSEClientContext(this.b) : new JSSEClientContext();
        this.e.setJSSEKeyManager(x509KeyManager);
        this.e.setEnabledCipherSuiteList(new CipherSuiteList(3));
        this.e.setSessionManager(new JSSESessionManager());
        this.e.setDebugStream(null);
        if (this.c != null) {
            f.println("New Context : KeyManager -> add CLientCredentials to Context");
            this.a("RSA");
            this.a("DSA");
            this.a("DH");
        } else {
            f.println("No KeyManager present, no ClientCredentials added");
        }
        this.e.updateCipherSuites();
        if (this.a != null) {
            f.println("Setting Trust Manager" + this.a);
            this.e.setChainVerifier(new JSSEChainVerifier(this.a));
        } else {
            this.e.setChainVerifier(new JSSEChainVerifier(this.a));
            f.println("No TrustManager present, all Certificates will be rejected");
        }
    }

    public IAIKSSLSocketFactory() {
        this(Util.getDefaultTrustManager(), Util.getDefaultKeyManager(), null);
        f.println("Default Factory");
    }
}

