/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.util.prop.impl;

import com.sap.aii.util.prop.api.PropertySet;
import com.sap.aii.util.prop.impl.BasicPropertySource;
import java.util.Properties;

public class JnlpPropertySource
extends BasicPropertySource {
    public static final String PREFIX = "jnlp";
    public static final String JNLP_CLIENT = "jnlp.client";

    public JnlpPropertySource() {
        super(new JnlpPropertiesAdapter());
    }

    public JnlpPropertySource(Properties parameters) {
        this();
    }

    public String getName() {
        return "JnlpPropertySource";
    }

    protected static class JnlpPropertiesAdapter
    implements PropertySet {
        protected JnlpPropertiesAdapter() {
        }

        public String[] getPropertyNames() {
            return new String[0];
        }

        public String getProperty(String key) {
            key = "jnlp." + key;
            return System.getProperty(key);
        }

        public void setProperty(String key, String value) {
            key = "jnlp." + key;
            if (value == null) {
                value = "";
            }
            System.setProperty(key, value);
        }

        public void deleteProperty(String key) {
            this.setProperty(key, "");
        }
    }
}

