/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.util.misc.api;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Stack;

public class WorkQueue {
    private Stack stack = new Stack();
    private Set objects = new HashSet();
    private boolean allowDuplicates;

    public WorkQueue(boolean allowDuplicates) {
        this.allowDuplicates = allowDuplicates;
    }

    public synchronized void addAll(Collection c) {
        if (this.allowDuplicates) {
            this.objects.addAll(c);
            this.stack.addAll(c);
        } else {
            Iterator i = c.iterator();
            while (i.hasNext()) {
                this.push(i.next());
            }
        }
    }

    public synchronized void push(Object obj) {
        if (this.allowDuplicates || !this.objects.contains(obj)) {
            this.objects.add(obj);
            this.stack.push(obj);
        }
    }

    public synchronized Object pop() {
        return this.stack.pop();
    }

    public synchronized int size() {
        return this.stack.size();
    }

    public synchronized boolean isEmpty() {
        return this.stack.isEmpty();
    }
}

