/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.util.misc.api;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;

public class Util {
    private static char[] toHex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static byte[] fromHex = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, -1, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
    private static final int BLOCK_SIZE = 512;

    private Util() {
    }

    public static String byteToHex(byte b) {
        char[] result = new char[]{toHex[(b & 0xF0) >> 4], toHex[b & 0xF]};
        return new String(result);
    }

    private static void throwNumberFormatException(String hex) throws NumberFormatException {
        throw new NumberFormatException("\"" + hex + "\" is no hex number.");
    }

    public static byte hexToByte(String hex) throws NumberFormatException {
        int highNibble;
        if (hex == null) {
            return 0;
        }
        int len = hex.length();
        if (len > 2) {
            throw new NumberFormatException("\"" + hex + "\" is too long for one byte (max. length=2)");
        }
        byte lowNibble = len > 0 ? fromHex[hex.charAt(len - 1)] : (byte)0;
        int n = highNibble = len > 1 ? fromHex[hex.charAt(len - 2)] : 0;
        if (highNibble == -1 || lowNibble == -1) {
            Util.throwNumberFormatException(hex);
        }
        return (byte)((byte)(highNibble << 4) + lowNibble);
    }

    public static String byteArrayToHex(byte[] b) {
        if (b == null) {
            return null;
        }
        char[] result = new char[b.length * 2];
        int pos = 0;
        int i = 0;
        while (i < b.length) {
            byte x = b[i];
            result[pos++] = toHex[(x & 0xF0) >> 4];
            result[pos++] = toHex[x & 0xF];
            ++i;
        }
        return new String(result);
    }

    public static byte[] hexToByteArray(String hex) {
        byte[] result;
        if (hex == null) {
            return null;
        }
        int len = hex.length();
        int size = len / 2;
        int startpos = 0;
        if (len % 2 == 1) {
            result = new byte[++size];
            result[0] = fromHex[hex.charAt(0)];
            startpos = 1;
            if (result[0] == -1) {
                Util.throwNumberFormatException(hex);
            }
        } else {
            result = new byte[size];
            startpos = 0;
        }
        int bufferSize = size > 512 ? 1024 : 2 * size;
        char[] buffer = new char[bufferSize];
        int hexOffset = startpos;
        int blockStart = startpos;
        while (blockStart < size) {
            int blockEnd = blockStart + 512;
            if (blockEnd > size) {
                blockEnd = size;
            }
            hex.getChars(hexOffset, hexOffset + (blockEnd - blockStart) * 2, buffer, 0);
            int bufpos = 0;
            int j = blockStart;
            while (j < blockEnd) {
                byte highNibble = fromHex[buffer[bufpos++]];
                byte lowNibble = fromHex[buffer[bufpos++]];
                if (highNibble == -1 || lowNibble == -1) {
                    Util.throwNumberFormatException(hex);
                }
                result[j] = (byte)((byte)(highNibble << 4) + lowNibble);
                ++j;
            }
            hexOffset += 1024;
            blockStart += 512;
        }
        return result;
    }

    public static int parseIntDefault(String s, int defaultValue) {
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException ex) {
            return defaultValue;
        }
    }

    public static Object findMapValue(Map map, Object value) {
        Iterator i = map.keySet().iterator();
        while (i.hasNext()) {
            Object key = i.next();
            if (!value.equals(map.get(key))) continue;
            return key;
        }
        return null;
    }

    public static Iterator sort(Iterator in, Comparator comp) {
        LinkedList list = new LinkedList();
        while (in.hasNext()) {
            list.add(in.next());
        }
        if (comp == null) {
            Collections.sort(list);
        } else {
            Collections.sort(list, comp);
        }
        return list.iterator();
    }

    public static Enumeration sort(Enumeration in, Comparator comp) {
        LinkedList list = new LinkedList();
        while (in.hasMoreElements()) {
            list.add(in.nextElement());
        }
        if (comp == null) {
            Collections.sort(list);
        } else {
            Collections.sort(list, comp);
        }
        return Collections.enumeration(list);
    }

    public static String getClassName(Object obj) {
        String className = obj.getClass().getName();
        int pos = className.lastIndexOf(46);
        if (pos < 0) {
            return className;
        }
        return className.substring(pos + 1);
    }

    public static String getStackTrace(Throwable eX) {
        StringWriter sw = new StringWriter();
        eX.printStackTrace(new PrintWriter(sw));
        return sw.getBuffer().toString();
    }
}

