/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.util.misc.api;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;

public class StringUtil {
    private StringUtil() {
    }

    public static String getString(String s) {
        if (s == null) {
            return "";
        }
        return s;
    }

    public static String fill(String s, int max) {
        int len = s.length();
        if (len >= max) {
            return s.substring(0, max);
        }
        StringBuffer sb = new StringBuffer(max);
        sb.append(s);
        int i = len;
        while (i < max) {
            sb.append(' ');
            ++i;
        }
        return sb.toString();
    }

    public static boolean contains(String s, char c) {
        return s.indexOf(c) != -1;
    }

    public static void replaceChar(StringBuffer buff, char c, String s) {
        int len = s.length();
        int pos = buff.toString().indexOf(c);
        while (pos > -1) {
            buff.replace(pos, pos + 1, s);
            pos = buff.toString().indexOf(c, pos + len);
        }
    }

    public static void replaceSubString(StringBuffer buff, String old_str, String new_str) {
        int old_len = old_str.length();
        int new_len = new_str.length();
        int pos = buff.toString().indexOf(old_str);
        while (pos > -1) {
            buff.replace(pos, pos + old_len, new_str);
            pos = buff.toString().indexOf(old_str, pos + new_len);
        }
    }

    public static String escapeXMLChars(String aString) {
        if (aString == null) {
            return aString;
        }
        StringBuffer lBuffer = null;
        int lSourceCopyStartPos = 0;
        int i = 0;
        while (i < aString.length()) {
            char lCurrentChar = aString.charAt(i);
            String lReplacementForCurrentChar = null;
            switch (lCurrentChar) {
                case '&': {
                    lReplacementForCurrentChar = "&amp;";
                    break;
                }
                case '\"': {
                    lReplacementForCurrentChar = "&quot;";
                    break;
                }
                case '<': {
                    lReplacementForCurrentChar = "&lt;";
                    break;
                }
                case '>': {
                    lReplacementForCurrentChar = "&gt;";
                    break;
                }
                case '\'': {
                    lReplacementForCurrentChar = "&apos;";
                    break;
                }
            }
            if (lReplacementForCurrentChar != null) {
                if (lBuffer == null) {
                    lBuffer = new StringBuffer(2 * aString.length());
                }
                String lBacklog = aString.substring(lSourceCopyStartPos, i);
                lBuffer.append(lBacklog);
                lBuffer.append(lReplacementForCurrentChar);
                lSourceCopyStartPos = i + 1;
            }
            ++i;
        }
        if (lBuffer != null && lSourceCopyStartPos < aString.length()) {
            String lBacklog = aString.substring(lSourceCopyStartPos, aString.length());
            lBuffer.append(lBacklog);
        }
        return lBuffer == null ? aString : lBuffer.toString();
    }

    public static String unescapeXMLChars(String aString) {
        if (aString == null) {
            return aString;
        }
        StringBuffer lBuffer = null;
        int lSourceCopyStartPos = 0;
        int lLength = aString.length();
        int i = 0;
        while (i < lLength) {
            char lCurrentChar = aString.charAt(i);
            Character lReplacement = null;
            if (lCurrentChar != '&') {
                ++i;
                continue;
            }
            int lCurrentPos = i;
            int j = i + 6 < lLength ? i + 6 : lLength;
            String lEscapedCharCandidate = aString.substring(i, j);
            if (lEscapedCharCandidate.startsWith("&quot;")) {
                lReplacement = new Character('\"');
                i += 6;
            } else if (lEscapedCharCandidate.startsWith("&apos;")) {
                lReplacement = new Character('\'');
                i += 6;
            } else if (lEscapedCharCandidate.startsWith("&lt;")) {
                lReplacement = new Character('<');
                i += 4;
            } else if (lEscapedCharCandidate.startsWith("&gt;")) {
                lReplacement = new Character('>');
                i += 4;
            } else if (lEscapedCharCandidate.startsWith("&amp;")) {
                lReplacement = new Character('&');
                i += 5;
            } else {
                ++i;
            }
            if (lReplacement == null) continue;
            if (lBuffer == null) {
                lBuffer = new StringBuffer(aString.length());
            }
            String lBacklog = aString.substring(lSourceCopyStartPos, lCurrentPos);
            lBuffer.append(lBacklog);
            lBuffer.append(lReplacement);
            lSourceCopyStartPos = i;
        }
        if (lBuffer != null && lSourceCopyStartPos < aString.length()) {
            String lBacklog = aString.substring(lSourceCopyStartPos, aString.length());
            lBuffer.append(lBacklog);
        }
        return lBuffer == null ? aString : lBuffer.toString();
    }

    public static String escapeHTMLChars(String s) {
        if (s == null) {
            return s;
        }
        StringBuffer sb = new StringBuffer(2 * s.length());
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            switch (c) {
                case '&': {
                    sb.append("&amp;");
                    break;
                }
                case '\"': {
                    sb.append("&quot;");
                    break;
                }
                case '<': {
                    sb.append("&lt;");
                    break;
                }
                case '>': {
                    sb.append("&gt;");
                    break;
                }
                default: {
                    sb.append(c);
                }
            }
            ++i;
        }
        return sb.toString();
    }

    public static String removeTrailingBlanks(String s) {
        if (s == null) {
            return null;
        }
        int index = s.length() - 1;
        while (index >= 0 && s.charAt(index) == ' ') {
            --index;
        }
        return s.substring(0, index + 1);
    }

    public static String createHomogenousString(char c, int length) {
        char[] array = new char[length];
        int i = 0;
        while (i < length) {
            array[i] = c;
            ++i;
        }
        return new String(array);
    }

    public static boolean isStringEmpty(String s) {
        return s == null || s.trim().length() == 0;
    }

    public static boolean equalsPattern(String source, String pattern) {
        block22: {
            block23: {
                int i;
                if (source == null || source.length() == 0) {
                    return pattern == null || pattern.length() == 0;
                }
                if (pattern == null || pattern.length() == 0) {
                    return true;
                }
                int asteriks = 42;
                int question = 63;
                int escape = 35;
                int patternIndex = 0;
                int sourceIndex = 0;
                while (true) {
                    char patternChar;
                    if ((patternChar = pattern.charAt(patternIndex)) == '*') {
                        int i2;
                        int i1;
                        do {
                            if (++patternIndex < pattern.length()) continue;
                            return true;
                        } while ((patternChar = pattern.charAt(patternIndex)) == '*' || patternChar == '?');
                        while ((i1 = pattern.indexOf(42, patternIndex)) > 0 && pattern.charAt(i1 - 1) == '#') {
                        }
                        while ((i2 = pattern.indexOf(63, patternIndex)) > 0 && pattern.charAt(i1 - 1) == '#') {
                        }
                        int index = pattern.length();
                        if (i1 > 0 && i2 > 0) {
                            index = i1 > i2 ? i2 : i1;
                        } else if (i1 > 0) {
                            index = i1;
                        } else if (i2 > 0) {
                            index = i2;
                        }
                        String subPattern = pattern.substring(patternIndex, index);
                        StringBuffer buf = new StringBuffer(subPattern);
                        int subPattern_i = 0;
                        while (subPattern_i < buf.length()) {
                            if (buf.charAt(subPattern_i) == '#') {
                                buf.deleteCharAt(subPattern_i);
                            }
                            ++subPattern_i;
                        }
                        int subIndex = source.indexOf(subPattern, sourceIndex);
                        if (subIndex >= 0) {
                            sourceIndex = subIndex + subPattern.length();
                            patternIndex = index;
                            if (patternIndex < pattern.length()) continue;
                            return true;
                        }
                        return false;
                    }
                    if (patternChar == '?' || patternChar == source.charAt(sourceIndex)) {
                        ++sourceIndex;
                        if (++patternIndex >= pattern.length()) {
                            return sourceIndex >= source.length();
                        }
                        if (sourceIndex < source.length()) continue;
                        i = patternIndex;
                        while (i < pattern.length()) {
                            if (pattern.charAt(i) != '*') {
                                return false;
                            }
                            ++i;
                        }
                        return true;
                    }
                    if (patternChar != '#') break block22;
                    if ((patternChar = pattern.charAt(++patternIndex)) != source.charAt(sourceIndex)) break block23;
                    ++sourceIndex;
                    if (++patternIndex >= pattern.length()) {
                        return sourceIndex >= source.length();
                    }
                    if (sourceIndex >= source.length()) break;
                }
                i = patternIndex;
                while (i < pattern.length()) {
                    if (pattern.charAt(i) != '*') {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    private static void addParameter(StringBuffer sb, String key, String value) {
        if (sb.length() > 0) {
            sb.append('&');
        }
        sb.append(key).append('=').append(value);
    }

    public static String buildQueryString(Map param) {
        StringBuffer result = new StringBuffer();
        Iterator i = param.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            Object value = param.get(key);
            if (value instanceof String) {
                StringUtil.addParameter(result, key, (String)value);
                continue;
            }
            if (value instanceof String[]) {
                String[] array = (String[])value;
                int j = 0;
                while (j < array.length) {
                    StringUtil.addParameter(result, key, array[j]);
                    ++j;
                }
                continue;
            }
            throw new IllegalArgumentException();
        }
        return result.toString();
    }

    public static Hashtable parseQueryString(String s) {
        Hashtable<String, Object> result = new Hashtable<String, Object>();
        StringTokenizer st = new StringTokenizer(s, "&");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            int pos = token.indexOf(61);
            if (pos < 0) {
                throw new IllegalArgumentException(token);
            }
            String key = token.substring(0, pos);
            String value = token.substring(pos + 1);
            if (!result.containsKey(key)) {
                result.put(key, new Vector());
            }
            ((Vector)result.get(key)).add(value);
        }
        Iterator i = result.keySet().iterator();
        while (i.hasNext()) {
            Object key = i.next();
            Vector value = (Vector)result.get(key);
            if (value.size() == 1) {
                result.put((String)key, value.firstElement());
                continue;
            }
            result.put((String)key, value.toArray(new String[0]));
        }
        return result;
    }

    public static String replaceRegions(String str, String pattern, String replacement) {
        StringBuffer buf = new StringBuffer();
        if (str == null || pattern == null || replacement == null) {
            throw new IllegalArgumentException("Parameters should not be null");
        }
        int i = str.indexOf(pattern);
        int len = pattern.length();
        while (i >= 0) {
            buf.append(str.substring(0, i)).append(replacement);
            str = str.substring(i + len);
            i = str.indexOf(pattern);
        }
        buf.append(str);
        return buf.toString();
    }

    public static String[] splitStringAtDotintoArraySeparatedBySpace(String str) {
        int l = 0;
        StringTokenizer LTokenizer = new StringTokenizer(str, ".");
        l = LTokenizer.countTokens();
        String[] LReturnArray = new String[2 * l - 1];
        l = 0;
        while (LTokenizer.hasMoreTokens()) {
            if (l != 0) {
                LReturnArray[l - 1] = " ";
            }
            LReturnArray[l] = LTokenizer.nextToken();
            l += 2;
        }
        return LReturnArray;
    }
}

