/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.util.misc.api;

import com.sap.aii.util.misc.api.StringTooLongException;
import com.sap.aii.util.misc.api.StringUtil;
import java.io.Serializable;

public class StringMaxLeng
implements Serializable,
Comparable,
Cloneable {
    private static final long serialVersionUID = 42L;
    private int maxLeng = 0;
    protected String s;

    public StringMaxLeng(int maxLeng) {
        this.maxLeng = maxLeng;
        this.s = "";
    }

    public StringMaxLeng(String s, int maxLeng) throws StringTooLongException {
        s = StringUtil.removeTrailingBlanks(s);
        if (s.length() > maxLeng) {
            throw new StringTooLongException(s, maxLeng);
        }
        this.s = s;
        this.maxLeng = maxLeng;
    }

    public String toString() {
        return this.s;
    }

    public int length() {
        return this.s.length();
    }

    public int maxLength() {
        return this.maxLeng;
    }

    public boolean equals(StringMaxLeng o) {
        return o != null && this.s.equals(o.s);
    }

    public boolean equals(Object o) {
        return o instanceof StringMaxLeng && this.equals((StringMaxLeng)o);
    }

    public int compareTo(Object o) throws ClassCastException {
        if (o instanceof StringMaxLeng) {
            return this.s.compareTo(o.toString());
        }
        throw new ClassCastException();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void append(String str, boolean cut) throws StringTooLongException {
        int r = this.maxLeng - this.length();
        if (r < (str = StringUtil.removeTrailingBlanks(str)).length()) {
            if (!cut) throw new StringTooLongException(this.s + str, this.maxLeng);
            this.s = this.s + str.substring(0, r);
            return;
        } else {
            this.s = this.s + str;
        }
    }

    public boolean append(String str) {
        boolean b = true;
        boolean c = false;
        while (b) {
            b = false;
            try {
                this.append(str, c);
            }
            catch (StringTooLongException e) {
                c = true;
                b = true;
            }
        }
        return !c;
    }

    public int hashCode() {
        return this.s.hashCode();
    }
}

