/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.util.misc.api;

import com.sap.aii.util.base64.api.Base64;
import com.sap.aii.util.blob.api.AIIBlob;
import com.sap.aii.util.blob.api.BlobServices;
import com.sap.aii.util.log.api.Logger;
import com.sap.aii.util.misc.api.GUIDFactory;
import com.sap.aii.util.misc.api.ResourceException;
import com.sap.aii.util.misc.api.StringUtil;
import com.sap.guid.GUIDFormatException;
import com.sap.guid.IGUID;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class StringConversion {
    private static final Logger logger = Logger.getLogger((class$com$sap$aii$util$misc$api$StringConversion == null ? (class$com$sap$aii$util$misc$api$StringConversion = StringConversion.class$("com.sap.aii.util.misc.api.StringConversion")) : class$com$sap$aii$util$misc$api$StringConversion).getName());
    static /* synthetic */ Class class$com$sap$aii$util$misc$api$StringConversion;

    private StringConversion() {
    }

    public static String AIIBlob2String(AIIBlob value, boolean doZip, boolean includeMimetype) throws ResourceException {
        if (value == null) {
            return null;
        }
        byte[] bytes = BlobServices.getByteArray(value);
        if (doZip) {
            ByteArrayOutputStream target = new ByteArrayOutputStream();
            ZipOutputStream zip = new ZipOutputStream(target);
            try {
                zip.putNextEntry(new ZipEntry("value"));
                zip.write(bytes);
                zip.close();
            }
            catch (IOException e) {
                throw new ResourceException(e);
            }
            bytes = target.toByteArray();
        }
        String prefix = "";
        if (includeMimetype) {
            String mimeType = value.getMimeType();
            if (mimeType == null) {
                prefix = "!!!";
            } else if (!mimeType.equals("any")) {
                prefix = "!" + mimeType + "!";
            }
        }
        return prefix + Base64.encode(bytes);
    }

    public static AIIBlob String2AIIBlob(String value, boolean isZipped) throws ResourceException {
        if (value == null) {
            return null;
        }
        int offset = 0;
        String mimeType = null;
        if (value.length() > 0 && value.charAt(0) == '!') {
            if (value.startsWith("!!!")) {
                offset = 3;
            } else {
                offset = value.indexOf(33, 1);
                if (offset == -1) {
                    return null;
                }
                mimeType = value.substring(1, offset);
                ++offset;
            }
        } else {
            mimeType = "any";
        }
        byte[] bytes = Base64.decode(value.substring(offset));
        if (isZipped) {
            ZipInputStream is = new ZipInputStream(new ByteArrayInputStream(bytes));
            try {
                is.getNextEntry();
            }
            catch (IOException e) {
                throw new ResourceException(e);
            }
            return BlobServices.getBlob(is, -1, mimeType);
        }
        return BlobServices.getBlobFromArray(bytes, mimeType);
    }

    public static String guid2HexString(IGUID guid) {
        if (guid == null) {
            return null;
        }
        return guid.toHexString();
    }

    public static String byteArray2String(byte[] value) {
        if (value == null) {
            return null;
        }
        return Base64.encode(value);
    }

    public static byte[] String2byteArray(String value) {
        if (value == null) {
            return null;
        }
        return Base64.decode(value);
    }

    public static IGUID hexString2guid(String hexGuid) throws GUIDFormatException {
        if (hexGuid == null) {
            return null;
        }
        return GUIDFactory.getInstance().parseHexGUID(hexGuid);
    }

    public static String boolean2String(boolean value) {
        if (value) {
            return Boolean.TRUE.toString();
        }
        return Boolean.FALSE.toString();
    }

    public static boolean String2boolean(String value) {
        return Boolean.TRUE.toString().equalsIgnoreCase(value);
    }

    public static String int2String(int value) {
        return Integer.toString(value);
    }

    public static int String2int(String value) {
        if (value == null) {
            return 0;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public static String Timestamp2String(Timestamp value) {
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    public static Timestamp String2Timestamp(String value) {
        if (value == null) {
            return null;
        }
        try {
            return Timestamp.valueOf(value);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static String[] String2StringArray(String string) {
        ArrayList<String> list = new ArrayList<String>();
        int i = string.indexOf("::");
        while (i >= 0) {
            StringBuffer buff = new StringBuffer(string.substring(0, i));
            StringUtil.replaceSubString(buff, "_:_", ":");
            list.add(buff.toString());
            string = string.length() > i + 2 ? string.substring(i + 2, string.length()) : "";
            i = string.indexOf("::");
        }
        String[] stringArray = new String[list.size()];
        list.toArray(stringArray);
        return stringArray;
    }

    public static String StringArray2String(String[] stringArray) {
        String resultString = "";
        int i = 0;
        while (i < stringArray.length) {
            StringBuffer buff = new StringBuffer(stringArray[i]);
            StringUtil.replaceSubString(buff, ":", "_:_");
            resultString = resultString + buff.toString() + "::";
            ++i;
        }
        return resultString;
    }

    public static String char2String(char c) {
        return String.valueOf(c);
    }

    public static char String2char(String s) {
        return s != null && s.length() > 0 ? s.charAt(0) : (char)'\u0000';
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

