/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.util.misc.api;

import java.util.Vector;

public class StrictTokenizer {
    private Vector v = new Vector();
    private int current = 0;

    public StrictTokenizer(String str, char delim) {
        if (str == null) {
            return;
        }
        StringBuffer buf = new StringBuffer(str);
        buf.append(delim);
        int bufLength = buf.length();
        int startIndex = 0;
        int i = 0;
        while (i < bufLength) {
            if (buf.charAt(i) == delim) {
                this.v.addElement(buf.substring(startIndex, i));
                startIndex = i + 1;
            }
            ++i;
        }
    }

    public boolean hasMoreTokens() {
        return this.current < this.v.size();
    }

    public String nextToken() {
        if (this.current >= this.v.size()) {
            return null;
        }
        return (String)this.v.elementAt(this.current++);
    }

    public static void main(String[] args) {
        StrictTokenizer.tokenize("bla,fasel,hurz");
        StrictTokenizer.tokenize(null);
        StrictTokenizer.tokenize("");
        StrictTokenizer.tokenize(",");
        StrictTokenizer.tokenize(",,");
    }

    private static void tokenize(String s) {
        StrictTokenizer t = new StrictTokenizer(s, ',');
        while (t.hasMoreTokens()) {
            System.err.println("<" + t.nextToken() + ">");
        }
        System.err.println("--------");
    }
}

