/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.util.misc.api;

import com.sap.aii.util.log.api.Level;
import com.sap.aii.util.misc.api.BabelMessage;
import com.sap.aii.util.misc.api.IBaseException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.Locale;

public class ServerExceptionInfo
implements Serializable {
    private static final long serialVersionUID = 42L;
    private boolean wrapBeforeVisualisation = false;
    private Level severity = Level.ERROR;
    private BabelMessage babelMessage = null;
    private String message = null;
    private String messageId;
    private String stackTrace;
    private String exceptionName;
    private Locale userLocale = null;

    public ServerExceptionInfo(Throwable throwable) {
        this.exceptionName = throwable.getClass().getName().toString();
        if (throwable instanceof IBaseException) {
            this.wrapBeforeVisualisation = ((IBaseException)((Object)throwable)).getWrapBeforeVisualisation();
            this.severity = ((IBaseException)((Object)throwable)).getSeverity();
            this.messageId = ((IBaseException)((Object)throwable)).getErrorCode();
            this.babelMessage = ((IBaseException)((Object)throwable)).getBabelMessage();
        } else {
            this.messageId = this.exceptionName;
            this.message = throwable.getMessage();
            if (this.message == null || this.message.length() <= 0) {
                this.message = this.exceptionName;
            }
        }
        this.stackTrace = this.stackTraceToString(throwable);
    }

    public String getErrorCode() {
        return this.messageId;
    }

    public String getMessage() {
        if (this.babelMessage != null) {
            return this.babelMessage.toString();
        }
        return this.message;
    }

    public BabelMessage getBabelMessage() {
        return this.babelMessage;
    }

    public String getMessage(Locale locale) {
        if (this.babelMessage != null) {
            return this.babelMessage.toString(locale);
        }
        return this.message;
    }

    public Level getSeverity() {
        return this.severity;
    }

    public boolean getWrapBeforeVisualisation() {
        return this.wrapBeforeVisualisation;
    }

    public String getStackTrace() {
        return this.stackTrace;
    }

    public String getExceptionName() {
        return this.exceptionName;
    }

    public String toString() {
        return "message: " + this.getMessage() + "; error code: " + this.getErrorCode() + "\nexception name: " + this.getExceptionName() + "; wrapBeforeVisualisation: " + this.getWrapBeforeVisualisation() + "\nseverity: " + this.getSeverity() + "\nstackTrace: " + this.getStackTrace();
    }

    private String stackTraceToString(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        return stringWriter.toString();
    }
}

