/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.util.misc.api;

import com.sap.aii.util.misc.api.AbstractMessage;
import com.sap.aii.util.misc.api.InteractionMap;
import com.sap.aii.util.misc.api.Message;
import java.util.Locale;
import java.util.Vector;

public class MessageTable
extends AbstractMessage {
    private static final long serialVersionUID = 42L;
    public static final int NO_BORDER = 0;
    public static final int SOLID_BORDER = 1;
    private int style = 0;
    private Message[] header;
    private Vector rows = new Vector();

    public MessageTable() {
    }

    public MessageTable(int style) {
        this.setStyle(style);
    }

    public int getStyle() {
        return this.style;
    }

    public void setStyle(int style) {
        if (style < 0 || style > 1) {
            throw new IllegalArgumentException("Style must be one of NO_BORDER or SOLID_BORDER.");
        }
        this.style = style;
    }

    public void setHeader(Message[] header) {
        this.header = header;
    }

    public void addRow(Message[] row) {
        if (row != null) {
            this.rows.add(row);
        }
    }

    public void finallyLocalize(Locale locale) {
        int j;
        if (this.header != null) {
            j = 0;
            while (j < this.header.length) {
                this.header[j].finallyLocalize(locale);
                ++j;
            }
        }
        int i = 0;
        while (i < this.rows.size()) {
            Message[] row = (Message[])this.rows.get(i);
            j = 0;
            while (j < row.length) {
                row[j].finallyLocalize(locale);
                ++j;
            }
            ++i;
        }
    }

    public String toHTML(Locale locale, InteractionMap imap) {
        String tableAtts = " border='0'";
        String cellAtts = "";
        if (this.style == 1) {
            tableAtts = " border='1' style='border-style:solid'";
            cellAtts = " style='border-style:solid'";
        }
        StringBuffer buf = new StringBuffer("<table" + tableAtts + ">");
        int i = -1;
        while (i < this.rows.size()) {
            block4: {
                Message[] row;
                block5: {
                    block3: {
                        if (i != -1) break block3;
                        if (this.header == null) break block4;
                        row = this.header;
                        break block5;
                    }
                    row = (Message[])this.rows.get(i);
                }
                buf.append("<tr>");
                int j = 0;
                while (j < row.length) {
                    buf.append(i == -1 ? "<th" : "<td");
                    buf.append(cellAtts + ">");
                    String cell = row[j].toHTML(locale, imap);
                    buf.append(cell);
                    buf.append(i == -1 ? "</th>\n" : "</td>\n");
                    ++j;
                }
                buf.append("</tr>\n");
            }
            ++i;
        }
        buf.append("</table>");
        return buf.toString();
    }

    public String toString(Locale loc) {
        return "[TABLE]";
    }
}

