/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.util.misc.api;

import com.sap.aii.util.misc.api.AbstractMessage;
import com.sap.aii.util.misc.api.BabelMessage;
import com.sap.aii.util.misc.api.InteractionMap;
import com.sap.aii.util.misc.api.Message;
import com.sap.aii.util.misc.api.MessageHeading;
import com.sap.aii.util.misc.api.MessageTable;
import com.sap.aii.util.misc.api.StrictTokenizer;
import com.sap.aii.util.misc.api.StringUtil;
import java.util.Locale;
import java.util.Vector;

public class MessageList
extends AbstractMessage {
    private static final long serialVersionUID = 42L;
    public static final int FLAT = 0;
    public static final int NUMBERED = 1;
    public static final int BULLETED = 2;
    private int style = 0;
    private Vector messages = new Vector();

    public MessageList() {
    }

    public MessageList(int style) {
        this.setStyle(style);
    }

    public int getStyle() {
        return this.style;
    }

    public void setStyle(int style) {
        if (style < 0 || style > 2) {
            throw new IllegalArgumentException("Style must be one of FLAT, NUMBERED or BULLETED.");
        }
        this.style = style;
    }

    public MessageList add(Message msg) {
        if (msg != null) {
            this.messages.add(msg);
        }
        return this;
    }

    public MessageList add(int index, Message msg) {
        if (msg != null) {
            if (index < 0) {
                index = 0;
            }
            if (index > this.messages.size()) {
                index = this.messages.size();
            }
            this.messages.add(index, msg);
        }
        return this;
    }

    public MessageList addEmptyLine() {
        return this.add(BabelMessage.createFromString(""));
    }

    public Message get(int index) {
        if (index < 0 || index >= this.messages.size()) {
            return null;
        }
        return (Message)this.messages.elementAt(index);
    }

    public int size() {
        return this.messages.size();
    }

    public String toString(Locale loc) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < this.messages.size()) {
            String ding;
            switch (this.style) {
                case 1: {
                    ding = "" + (i + 1) + ". ";
                    break;
                }
                case 2: {
                    ding = "- ";
                    break;
                }
                default: {
                    ding = "";
                }
            }
            String space = StringUtil.createHomogenousString(' ', ding.length());
            Message element = (Message)this.messages.elementAt(i);
            if (element instanceof MessageList) {
                String elementString = element.toString(loc);
                StrictTokenizer tokenizer = new StrictTokenizer(elementString, '\n');
                boolean firstLine = true;
                boolean lastLine = false;
                while (tokenizer.hasMoreTokens()) {
                    String line = tokenizer.nextToken();
                    boolean bl = lastLine = !tokenizer.hasMoreTokens();
                    if (firstLine) {
                        buf.append(ding).append(line).append("\n");
                        firstLine = false;
                        continue;
                    }
                    if (lastLine) continue;
                    buf.append(space).append(line).append("\n");
                }
            } else {
                buf.append(ding).append(element.toString(loc)).append("\n");
            }
            ++i;
        }
        return buf.toString();
    }

    public String toHTML(Locale loc, InteractionMap imap) {
        String itemEnd;
        String itemStart;
        String listEnd;
        String listStart;
        StringBuffer buf = new StringBuffer();
        switch (this.style) {
            case 1: {
                listStart = "<ol>\n";
                listEnd = "</ol>";
                itemStart = "<li><p>";
                itemEnd = "\n";
                break;
            }
            case 2: {
                listStart = "<ul type=disc>";
                listEnd = "</ul>";
                itemStart = "<li><p>";
                itemEnd = "\n";
                break;
            }
            default: {
                listStart = "";
                listEnd = "";
                itemStart = "<br>";
                itemEnd = "\n";
            }
        }
        buf.append(listStart);
        Message previousMsg = null;
        int i = 0;
        while (i < this.messages.size()) {
            Message msg = (Message)this.messages.elementAt(i);
            boolean noBreak = this.style == 0 && (previousMsg == null || previousMsg instanceof MessageList && ((MessageList)previousMsg).style != 0 || previousMsg instanceof MessageTable || previousMsg instanceof MessageHeading || msg instanceof MessageList && ((MessageList)msg).style != 0 || msg instanceof MessageTable || msg instanceof MessageHeading);
            String elementString = msg.toHTML(loc, imap);
            if (!noBreak) {
                buf.append(itemStart);
            }
            buf.append(elementString);
            buf.append(itemEnd);
            previousMsg = msg;
            ++i;
        }
        buf.append(listEnd);
        return buf.toString();
    }

    public void finallyLocalize(Locale locale) {
        int i = 0;
        while (i < this.messages.size()) {
            ((Message)this.messages.elementAt(i)).finallyLocalize(locale);
            ++i;
        }
    }
}

