/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.util.misc.api;

import com.sap.aii.util.misc.api.AbstractMessage;
import com.sap.aii.util.misc.api.InteractionMap;
import com.sap.aii.util.misc.api.Message;
import java.util.Hashtable;
import java.util.Locale;

public class MessageAnchor
extends AbstractMessage {
    private static final long serialVersionUID = 42L;
    private Message msg;
    private String name;
    private String href;
    private Hashtable eventProperties;

    public MessageAnchor() {
    }

    public MessageAnchor(Message msg) {
        this.msg = msg;
    }

    public MessageAnchor(Message msg, String name, String href) {
        this.msg = msg;
        this.name = name;
        this.href = href;
    }

    public MessageAnchor(Message msg, Hashtable eventProperties) {
        this.msg = msg;
        this.eventProperties = eventProperties;
    }

    public String getHref() {
        return this.href;
    }

    public void setHref(String href) {
        this.href = href;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Hashtable getEventProperties() {
        return this.eventProperties;
    }

    public void setEventProperties(Hashtable eventProperties) {
        this.eventProperties = eventProperties;
    }

    public void setMessage(Message msg) {
        this.msg = msg;
    }

    public Message getMessage() {
        return this.msg;
    }

    public void finallyLocalize(Locale locale) {
        if (this.msg != null) {
            this.msg.finallyLocalize(locale);
        }
    }

    public String toHTML(Locale locale, InteractionMap imap) {
        String s = "";
        if (this.msg != null) {
            s = this.msg.toHTML(locale, imap);
        }
        String anchor = "<a";
        if (this.name != null) {
            anchor = anchor + " name='" + this.name + "'";
        }
        if (imap == null || this.eventProperties == null) {
            if (this.href != null) {
                anchor = anchor + " href='" + this.href + "'";
            }
        } else {
            String genHref = imap.addMapping(this.eventProperties);
            anchor = anchor + " href='" + genHref + "'";
        }
        return anchor + ">" + s + "</a>";
    }

    public String toString(Locale loc) {
        if (this.msg != null) {
            return this.msg.toString(loc);
        }
        return "";
    }
}

