/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.util.misc.api;

import com.sap.aii.util.misc.api.EncodingUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;

public class IOUtil {
    public static final String EOL = System.getProperty("line.separator", "\n");
    public static final String PATH_SEP = System.getProperty("path.separator", ";");
    public static final String FILE_SEP = System.getProperty("file.separator", "/");
    static final int BUFFER_SIZE = 1024;

    private IOUtil() {
    }

    public static int copyStream(InputStream in, OutputStream out) throws IOException {
        byte[] buffer = new byte[1024];
        int count = 0;
        int n = in.read(buffer);
        while (n > -1) {
            out.write(buffer, 0, n);
            count += n;
            n = in.read(buffer);
        }
        return count;
    }

    public static CopyStreamThread copyStreamASync(InputStream in, OutputStream out, boolean doClose) {
        CopyStreamThread thread = new CopyStreamThread(in, out, doClose);
        thread.start();
        return thread;
    }

    public static int copyCharStream(Reader in, Writer out) throws IOException {
        char[] buffer = new char[1024];
        int count = 0;
        int n = in.read(buffer);
        while (n > -1) {
            out.write(buffer, 0, n);
            count += n;
            n = in.read(buffer);
        }
        return count;
    }

    public static InputStream toInputStream(String s) {
        return new ByteArrayInputStream(s.getBytes());
    }

    public static boolean isEncodingSupported(String encoding) {
        return EncodingUtil.isEncodingSupported(encoding);
    }

    public static String getCanonicalEncodingName(String encoding) throws UnsupportedEncodingException {
        return EncodingUtil.getCanonicalEncodingName(encoding);
    }

    public static boolean isFileReadable(File file) {
        try {
            return file.canRead();
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String getFileName(File file) {
        try {
            return file.getCanonicalPath();
        }
        catch (Exception e) {
            return file.getPath();
        }
    }

    public static String getCanonicalFileName(String name) {
        try {
            return new File(name).getCanonicalPath();
        }
        catch (Exception e) {
            return name;
        }
    }

    public static class CopyStreamThread
    extends Thread {
        private InputStream in;
        private OutputStream out;
        private int count;
        private boolean doClose;
        private boolean stopCopy = false;
        private boolean finished = false;
        private IOException exception = null;

        public CopyStreamThread(InputStream in, OutputStream out, boolean doClose) {
            this.in = in;
            this.out = out;
            this.doClose = doClose;
            this.count = 0;
        }

        public void run() {
            byte[] buffer = new byte[1024];
            try {
                int n = this.in.read(buffer);
                while (!this.stopCopy && n > -1) {
                    this.out.write(buffer, 0, n);
                    this.count += n;
                    n = this.in.read(buffer);
                }
            }
            catch (IOException e) {
                this.exception = e;
            }
            if (this.doClose) {
                try {
                    this.out.close();
                    this.in.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.finished = true;
        }

        public void stopCopy() {
            this.stopCopy = true;
        }

        public int getCount() {
            return this.count;
        }

        public IOException getException() {
            return this.exception;
        }

        public boolean isFinished() {
            return this.finished;
        }
    }
}

