/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.util.misc.api;

import com.sap.aii.util.misc.api.BaseRuntimeException;
import com.sap.aii.util.misc.api.GUIDFactory;
import com.sap.guid.GUIDFormatException;
import com.sap.guid.IGUID;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;

public abstract class HelperFunctions {
    private static final String sNullStringRepresentation = "<null>";

    public static Map putIntoMap(Map aMap, Object[] aKeys, Object[] aValues) {
        if (aMap == null) {
            throw new IllegalArgumentException("Parameter aMap is null!");
        }
        if (aKeys == null) {
            throw new IllegalArgumentException("Parameter aKeys is null!");
        }
        if (aValues == null) {
            throw new IllegalArgumentException("Parameter aValues is null!");
        }
        if (aKeys.length != aValues.length) {
            throw new IllegalArgumentException("Parameters aKeys and aValues differ in length: " + aKeys.length + " vs. " + aValues.length + "!");
        }
        int i = 0;
        while (i < aKeys.length) {
            aMap.put(aKeys[i], aValues[i]);
            ++i;
        }
        return aMap;
    }

    public static Object[] extract(Object[] aSource, int aFromIncl, int aToExcl) {
        Object[] lSubArray = (Object[])Array.newInstance(aSource[0].getClass(), aToExcl - aFromIncl);
        int i = 0;
        while (i < aToExcl - aFromIncl) {
            lSubArray[i] = aSource[aFromIncl + i];
            ++i;
        }
        return lSubArray;
    }

    public static Cascaded cascaded(Map aMap) {
        return new Cascaded(aMap);
    }

    public static String arrayToString(Object[] aObjects) {
        if (aObjects == null) {
            return sNullStringRepresentation;
        }
        String lResult = "{";
        int i = 0;
        while (i < aObjects.length) {
            if (i > 0) {
                lResult = lResult + ",";
            }
            lResult = lResult + (aObjects[i] != null ? aObjects[i].toString() : sNullStringRepresentation);
            ++i;
        }
        lResult = lResult + "}";
        return lResult;
    }

    public static String tupelToString(Object aObject0) {
        return HelperFunctions.arrayToString(new Object[]{aObject0});
    }

    public static String tupelToString(Object aObject0, Object aObject1) {
        return HelperFunctions.arrayToString(new Object[]{aObject0, aObject1});
    }

    public static String tupelToString(Object aObject0, Object aObject1, Object aObject2) {
        return HelperFunctions.arrayToString(new Object[]{aObject0, aObject1, aObject2});
    }

    public static String tupelToString(Object aObject0, Object aObject1, Object aObject2, Object aObject3) {
        return HelperFunctions.arrayToString(new Object[]{aObject0, aObject1, aObject2, aObject3});
    }

    public static String tupelToString(Object aObject0, Object aObject1, Object aObject2, Object aObject3, Object aObject4) {
        return HelperFunctions.arrayToString(new Object[]{aObject0, aObject1, aObject2, aObject3, aObject4});
    }

    public static String tupelToString(Object aObject0, Object aObject1, Object aObject2, Object aObject3, Object aObject4, Object aObject5) {
        return HelperFunctions.arrayToString(new Object[]{aObject0, aObject1, aObject2, aObject3, aObject4, aObject5});
    }

    public static String mapToString(Map aMap) {
        Object[] lEntries = new String[aMap.size()];
        Iterator lIterator = aMap.entrySet().iterator();
        int lEntryIndex = 0;
        while (lIterator.hasNext()) {
            Map.Entry lEntry = lIterator.next();
            lEntries[lEntryIndex++] = HelperFunctions.tupelToString(lEntry.getKey(), lEntry.getValue());
        }
        return HelperFunctions.arrayToString(lEntries);
    }

    public static boolean existsClass(String aClassName) {
        try {
            Class<?> lClass = Class.forName(aClassName);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static boolean lessThan(byte[] aFirstOperand, byte[] aSecondOperand) {
        if (aFirstOperand == null || aSecondOperand == null) {
            return false;
        }
        int i = 0;
        while (i < aFirstOperand.length && i < aSecondOperand.length) {
            if (aFirstOperand[i] < aSecondOperand[i]) {
                return true;
            }
            ++i;
        }
        return aFirstOperand.length < aSecondOperand.length;
    }

    public static int compareTo(byte[] aFirstOperand, byte[] aSecondOperand) {
        if (Arrays.equals(aFirstOperand, aSecondOperand)) {
            return 0;
        }
        return HelperFunctions.lessThan(aFirstOperand, aSecondOperand) ? -1 : 1;
    }

    public static IGUID createGuidFromHexString(String aGuid) {
        try {
            return GUIDFactory.getInstance().parseHexGUID(aGuid);
        }
        catch (GUIDFormatException e) {
            throw new BaseRuntimeException(e.getMessage());
        }
    }

    public static String getThrowableAsString(Throwable aThrowable) {
        return "Message: " + aThrowable.getMessage() + "\nStacktrace:\n" + HelperFunctions.getStackTraceAsString(aThrowable);
    }

    public static String getStackTraceAsString(Throwable aThrowable) {
        StringWriter lStringWriter = new StringWriter();
        PrintWriter lPrintWriter = new PrintWriter(lStringWriter);
        aThrowable.printStackTrace(lPrintWriter);
        lPrintWriter.flush();
        lStringWriter.flush();
        return lStringWriter.toString();
    }

    public static String createString(char aCharacter, int aCount) {
        if (aCount == 0) {
            return "";
        }
        char[] lCharacters = new char[aCount];
        Arrays.fill(lCharacters, aCharacter);
        return new String(lCharacters);
    }

    public static String createString(String aString, int aCount) {
        if (aString == null) {
            return null;
        }
        StringBuffer lString = new StringBuffer();
        while (aCount-- > 0) {
            lString.append(aString);
        }
        return lString.toString();
    }

    public static void main(String[] args) {
        String lText = HelperFunctions.createString("0123456789", 10);
        System.out.println(lText);
        String lWrappedText = HelperFunctions.wrapString(lText, "\n", 10);
        System.out.println(lWrappedText);
    }

    public static String wrapString(String aText, String aSeparator, int aCount) {
        if (aText == null || aSeparator == null || "".equals(aSeparator)) {
            return null;
        }
        StringBuffer lWRappedText = new StringBuffer();
        int i = 0;
        while (i < aText.length()) {
            if (i > 0 && i % aCount == 0) {
                lWRappedText.append(aSeparator);
            }
            lWRappedText.append(aText.charAt(i));
            ++i;
        }
        return lWRappedText.toString();
    }

    public static String fillInArguments(String aBaseString, Object[] aArguments) {
        MessageFormat lMessageFormat = new MessageFormat("");
        lMessageFormat.applyPattern(aBaseString);
        return lMessageFormat.format(aArguments);
    }

    public static String trunc(String aString, int aMaxLength, boolean aAppendNoteIfTruncated) {
        String lTrunc;
        if (aString == null) {
            return null;
        }
        if (aMaxLength < 0) {
            throw new BaseRuntimeException("aMaxLength < 0");
        }
        if (aMaxLength == 0) {
            return "";
        }
        String string = lTrunc = aString.length() <= aMaxLength ? aString : aString.substring(0, aMaxLength - 1);
        if (aAppendNoteIfTruncated && lTrunc.length() != aString.length()) {
            String lNote = " ... (truncated, original length was " + aString.length() + ")";
            lTrunc = lTrunc + lNote;
        }
        return lTrunc;
    }

    public static String deriveUniformKey(String[] aKeyElements, int aMaxLength) {
        if (aMaxLength < 10) {
            throw new IllegalArgumentException("Parameter aMaxLength is " + aMaxLength + " - it must be larger than 10!");
        }
        int lMaxEffectiveLength = aMaxLength - 10;
        int lHashLength = 8;
        StringBuffer lConcatenation = new StringBuffer();
        int i = 0;
        while (i < aKeyElements.length) {
            if (i > 0) {
                lConcatenation.append('|');
            }
            lConcatenation.append(aKeyElements[i]);
            ++i;
        }
        if (lConcatenation.length() > lMaxEffectiveLength) {
            String lEffective = lConcatenation.substring(0, lMaxEffectiveLength);
            String lRemainder = lConcatenation.substring(lMaxEffectiveLength, lConcatenation.length());
            String lHash = Integer.toHexString(lRemainder.hashCode()).toUpperCase();
            return lEffective + ".." + lHash;
        }
        return lConcatenation.toString();
    }

    public static String rightAlign(String aText, int aWidth, char aPaddingCharacter) {
        return HelperFunctions.createString(aPaddingCharacter, aWidth - aText.length()) + aText;
    }

    public static String rightAlign(int aNumber, int aWidth, char aPaddingCharacter) {
        return HelperFunctions.rightAlign(String.valueOf(aNumber), aWidth, aPaddingCharacter);
    }

    public static class Cascaded {
        private Map iMap;

        private Cascaded(Map aMap) {
            this.iMap = aMap;
        }

        public Cascaded put(Object aKey, Object aValue) {
            this.iMap.put(aKey, aValue);
            return this;
        }

        public Cascaded remove(Object aKey) {
            this.iMap.remove(aKey);
            return this;
        }
    }

    private static class Dummy {
        private Dummy() {
        }
    }
}

