/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.util.misc.api;

import com.sap.aii.util.misc.api.GUID;
import com.sap.aii.util.misc.api.GUIDVersionException;
import com.sap.guid.GUIDFormatException;
import com.sap.guid.GUIDGeneratorFactory;
import com.sap.guid.IGUID;
import com.sap.guid.IGUIDGenerator;
import com.sap.guid.IGUIDGeneratorFactory;
import java.util.Properties;

public class GUIDFactory
implements IGUIDGenerator,
IGUIDGeneratorFactory {
    private static final GUIDFactory theInstance = new GUIDFactory();
    private IGUIDGenerator guidGenerator = this.getGuidGenerator();

    public static GUIDFactory getInstance() {
        return theInstance;
    }

    private GUIDFactory() {
    }

    private IGUIDGenerator getGuidGenerator() {
        IGUIDGenerator generator = GUIDGeneratorFactory.getInstance().createGUIDGenerator();
        try {
            generator.createGUID();
            return generator;
        }
        catch (Throwable e) {
            Properties props = new Properties();
            props.setProperty("forceNativeLibrary", "false");
            props.setProperty("forceMACAddress", "false");
            generator.setProperties(props);
            generator.createGUID();
            return generator;
        }
    }

    public IGUID createGUID() {
        return this.guidGenerator.createGUID();
    }

    public IGUID createGUID(byte[] g) throws GUIDFormatException {
        return this.guidGenerator.createGUID(g);
    }

    public IGUID createGUID(IGUID originalGUID, byte[] variantDescriptor) {
        return this.guidGenerator.createGUID(originalGUID, variantDescriptor);
    }

    public IGUID createGUID(int version) throws com.sap.guid.GUIDVersionException {
        return this.guidGenerator.createGUID(version);
    }

    public IGUID createGUID(String value) {
        return this.guidGenerator.createGUID(value);
    }

    public IGUID parseGUID(String guid) throws GUIDFormatException {
        return this.guidGenerator.parseGUID(guid);
    }

    public IGUID parseHexGUID(String guid) throws GUIDFormatException {
        return this.guidGenerator.parseHexGUID(guid);
    }

    public void setProperties(Properties props) {
        this.guidGenerator.setProperties(props);
    }

    public IGUIDGenerator createGUIDGenerator() {
        return this.guidGenerator;
    }

    public IGUIDGenerator createGUIDGenerator(Properties arg0) {
        return this.guidGenerator;
    }

    private class GUIDGeneratorImpl
    implements IGUIDGenerator {
        private GUIDGeneratorImpl() {
        }

        public IGUID createGUID() {
            return new GUID();
        }

        public IGUID createGUID(byte[] g) throws GUIDFormatException {
            return new GUID(g);
        }

        public IGUID createGUID(IGUID originalGUID, byte[] variantDescriptor) {
            return new GUID((GUID)originalGUID, variantDescriptor);
        }

        public IGUID createGUID(int version) throws com.sap.guid.GUIDVersionException {
            try {
                return new GUID(version);
            }
            catch (GUIDVersionException e) {
                throw new com.sap.guid.GUIDVersionException();
            }
        }

        public IGUID createGUID(String value) {
            return new GUID(value);
        }

        public IGUID parseGUID(String guid) throws GUIDFormatException {
            return GUID.parseGUID(guid);
        }

        public IGUID parseHexGUID(String guid) throws GUIDFormatException {
            return GUID.parseHexGUID(guid);
        }

        public void setProperties(Properties props) {
        }
    }
}

