/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.util.misc.api;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;

public class EncodingUtil {
    public static final String UTF_8 = "UTF-8";
    public static final String UTF_16 = "UTF-16";
    public static final String UTF_16BE = "UTF-16BE";
    public static final String UTF_16LE = "UTF-16LE";
    public static final String EBCDIC = "EBCDIC";
    public static final String UCS_4 = "UCS-4";

    private EncodingUtil() {
    }

    public static boolean isEncodingSupported(String encoding) {
        try {
            EncodingUtil.getCanonicalEncodingName(encoding);
            return true;
        }
        catch (UnsupportedEncodingException ex) {
            return false;
        }
    }

    public static String getCanonicalEncodingName(String encoding) throws UnsupportedEncodingException {
        String canonicalName = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)baos, encoding);
            canonicalName = osw.getEncoding();
            osw.close();
            baos.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return canonicalName;
    }

    public static String getEncodingOfXml(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        String encoding = null;
        encoding = EncodingUtil.getEncodingFromBOM(bytes);
        if (encoding != null) {
            return encoding;
        }
        String encodingFamily = EncodingUtil.getEncodingFamiliyOfXml(bytes);
        if (encodingFamily == null) {
            return null;
        }
        byte[] declarationBytes = null;
        if (bytes.length < 300) {
            declarationBytes = bytes;
        } else {
            declarationBytes = new byte[300];
            System.arraycopy(bytes, 0, declarationBytes, 0, 300);
        }
        try {
            String declaration = new String(declarationBytes, encodingFamily);
            return EncodingUtil.getDeclairedEncoding(declaration);
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public static String getDeclairedEncoding(String text) {
        if (text == null) {
            return null;
        }
        String encoding = null;
        int startIndex = text.indexOf("encoding=\"");
        if (startIndex == -1) {
            startIndex = text.indexOf("encoding='");
        }
        if (startIndex > 0) {
            int lastIndex = text.indexOf("\"?");
            if (lastIndex == -1) {
                lastIndex = text.indexOf("'?");
            }
            if (lastIndex > startIndex) {
                encoding = text.substring(startIndex + 10, lastIndex);
            }
        }
        return encoding;
    }

    public static String getEncodingFamiliyOfXml(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        if (bytes.length < 4) {
            throw new IllegalArgumentException("xmlBytes is not a xml byte array. It has less than 4 bytes");
        }
        if (EncodingUtil.startsWith(bytes, 0, 60, 0, 63)) {
            return UTF_16BE;
        }
        if (EncodingUtil.startsWith(bytes, 60, 0, 63, 0)) {
            return UTF_16LE;
        }
        if (EncodingUtil.startsWith(bytes, 60, 63, 120, 109)) {
            return UTF_8;
        }
        if (EncodingUtil.startsWith(bytes, 76, 111, 167, 148)) {
            return EBCDIC;
        }
        if (EncodingUtil.startsWith(bytes, 60, 0, 0, 0)) {
            return UCS_4;
        }
        if (EncodingUtil.startsWith(bytes, 0, 60, 0, 0)) {
            return UCS_4;
        }
        if (EncodingUtil.startsWith(bytes, 0, 0, 60, 0)) {
            return UCS_4;
        }
        if (EncodingUtil.startsWith(bytes, 0, 0, 0, 60)) {
            return UCS_4;
        }
        return null;
    }

    public static String getEncodingFromBOM(byte[] bytes) {
        if (bytes == null) {
            throw new NullPointerException("bytes is null");
        }
        if (bytes.length < 4) {
            throw new IllegalArgumentException("BOM cannot be investigated. Entered byte array has less than 4 bytes");
        }
        if (EncodingUtil.startsWith(bytes, 0, 0, 254, 255)) {
            return UCS_4;
        }
        if (EncodingUtil.startsWith(bytes, 255, 254, 0, 0)) {
            return UCS_4;
        }
        if (EncodingUtil.startsWith(bytes, 0, 0, 255, 254)) {
            return UCS_4;
        }
        if (EncodingUtil.startsWith(bytes, 254, 255, 0, 0)) {
            return UCS_4;
        }
        if (EncodingUtil.startsWith(bytes, 254, 255)) {
            return UTF_16BE;
        }
        if (EncodingUtil.startsWith(bytes, 255, 254)) {
            return UTF_16LE;
        }
        if (EncodingUtil.startsWith(bytes, 239, 187, 191)) {
            return UTF_8;
        }
        return null;
    }

    public static byte[] removeBOM(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        String encoding = EncodingUtil.getEncodingFromBOM(bytes);
        if (encoding == null) {
            return bytes;
        }
        Object result = null;
        if (encoding.equals(UCS_4)) {
            return EncodingUtil.cutOffFirstBytes(bytes, 4);
        }
        if (encoding.equals(UTF_16)) {
            return EncodingUtil.cutOffFirstBytes(bytes, 2);
        }
        if (encoding.equals(UTF_16LE)) {
            return EncodingUtil.cutOffFirstBytes(bytes, 2);
        }
        if (encoding.equals(UTF_16BE)) {
            return EncodingUtil.cutOffFirstBytes(bytes, 2);
        }
        if (encoding.equals(UTF_8)) {
            return EncodingUtil.cutOffFirstBytes(bytes, 3);
        }
        return bytes;
    }

    public static byte[] addBOMforUTF16BEorUTF16LE(byte[] bytes, String encoding) {
        String canEncoding;
        if (bytes == null) {
            return null;
        }
        if (encoding == null) {
            return bytes;
        }
        try {
            canEncoding = EncodingUtil.getCanonicalEncodingName(encoding);
        }
        catch (UnsupportedEncodingException e) {
            return bytes;
        }
        if (canEncoding == null) {
            return bytes;
        }
        try {
            if (canEncoding.equals(EncodingUtil.getCanonicalEncodingName(UTF_16BE))) {
                return EncodingUtil.addTwoBytes(bytes, 254, 255);
            }
            if (canEncoding.equals(EncodingUtil.getCanonicalEncodingName(UTF_16LE))) {
                return EncodingUtil.addTwoBytes(bytes, 255, 254);
            }
            if (canEncoding.equals(EncodingUtil.getCanonicalEncodingName(UTF_16))) {
                if (EncodingUtil.startsWith(bytes, 0, 60, 0, 63)) {
                    return EncodingUtil.addTwoBytes(bytes, 254, 255);
                }
                if (EncodingUtil.startsWith(bytes, 60, 0, 63, 0)) {
                    return EncodingUtil.addTwoBytes(bytes, 255, 254);
                }
                return bytes;
            }
            return bytes;
        }
        catch (UnsupportedEncodingException e) {
            return bytes;
        }
    }

    private static byte[] addTwoBytes(byte[] bytes, int one, int two) {
        if (bytes == null) {
            return null;
        }
        byte[] result = new byte[bytes.length + 2];
        System.arraycopy(bytes, 0, result, 2, bytes.length);
        result[0] = (byte)EncodingUtil.toByteFormat(one);
        result[1] = (byte)EncodingUtil.toByteFormat(two);
        return result;
    }

    private static byte[] cutOffFirstBytes(byte[] bytes, int numberOfCutOff) {
        if (bytes == null) {
            return null;
        }
        if (bytes.length < numberOfCutOff + 1) {
            return null;
        }
        int length = bytes.length - numberOfCutOff;
        byte[] result = new byte[length];
        System.arraycopy(bytes, numberOfCutOff, result, 0, length);
        return result;
    }

    private static int toByteFormat(int characterFormat) {
        if (characterFormat > 127) {
            return characterFormat - 256;
        }
        return characterFormat;
    }

    private static boolean startsWith(byte[] bytes, int first, int second, int third, int fourth) {
        if (!EncodingUtil.startsWith(bytes, first, second, third)) {
            return false;
        }
        return bytes[3] == (fourth = EncodingUtil.toByteFormat(fourth));
    }

    private static boolean startsWith(byte[] bytes, int first, int second, int third) {
        if (!EncodingUtil.startsWith(bytes, first, second)) {
            return false;
        }
        return bytes[2] == (third = EncodingUtil.toByteFormat(third));
    }

    private static boolean startsWith(byte[] bytes, int first, int second) {
        if (bytes == null) {
            return false;
        }
        first = EncodingUtil.toByteFormat(first);
        second = EncodingUtil.toByteFormat(second);
        if (bytes[0] != first) {
            return false;
        }
        return bytes[1] == second;
    }
}

