/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.util.misc.api;

import com.sap.aii.util.log.api.Level;
import com.sap.aii.util.log.api.Logger;
import com.sap.aii.util.misc.api.BabelMessage;
import com.sap.aii.util.misc.api.IBaseException;
import com.sap.aii.util.misc.api.Message;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Locale;

public class BaseException
extends Exception
implements IBaseException {
    static final String RB = "com.sap.aii.util.misc.api.rb_exception.";
    private static final long serialVersionUID = 42L;
    private static boolean INITIALIZED_AUTOLOG = false;
    private Throwable rootCause;
    private BabelMessage message;
    private Message assistance;
    private Level severity = Level.FATAL;
    private boolean wrapBeforeVisualisation = false;

    BaseException(boolean suppressAutolog) {
        this.setMessage(null);
        if (!suppressAutolog) {
            this.autolog();
        }
    }

    public BaseException() {
        this.setMessage(null);
        this.autolog();
    }

    public BaseException(Throwable rootCause) {
        this.setRootCause(rootCause);
        if (rootCause instanceof IBaseException) {
            this.setBabelMessage(((IBaseException)((Object)rootCause)).getBabelMessage());
            this.setAssistanceMessage(((IBaseException)((Object)rootCause)).getAssistanceMessage());
            this.setSeverity(((IBaseException)((Object)rootCause)).getSeverity());
        } else {
            this.setMessage(rootCause.getMessage());
        }
        this.autolog();
    }

    public BaseException(String msg) {
        this.setMessage(msg);
        this.autolog();
    }

    public BaseException(String msg, Throwable rootCause) {
        this.setRootCause(rootCause);
        this.setMessage(msg);
        if (rootCause != null && rootCause instanceof IBaseException) {
            this.setSeverity(((IBaseException)((Object)rootCause)).getSeverity());
        }
        this.autolog();
    }

    public BaseException(BabelMessage babelMessage) {
        this.setBabelMessage(babelMessage);
        this.autolog();
    }

    public BaseException(Level severity, BabelMessage babelMessage) {
        this.setBabelMessage(babelMessage);
        this.setSeverity(severity);
        this.autolog();
    }

    public BaseException(Level severity, BabelMessage babelMessage, BabelMessage assistanceMessage) {
        this.setBabelMessage(babelMessage);
        this.setAssistanceMessage(assistanceMessage);
        this.setSeverity(severity);
        this.autolog();
    }

    public BaseException(BabelMessage babelMessage, Throwable rootCause) {
        this.setRootCause(rootCause);
        this.setBabelMessage(babelMessage);
        if (rootCause != null && rootCause instanceof IBaseException) {
            this.setSeverity(((IBaseException)((Object)rootCause)).getSeverity());
        }
        this.autolog();
    }

    protected void autolog() {
        BaseException.autolog(this);
    }

    protected static void autolog(Throwable exception) {
        try {
            Throwable iBaseExceptionRootcause;
            if (!INITIALIZED_AUTOLOG) {
                Logger.getLogger("AutoLog").setUseParentHandlers(false);
                INITIALIZED_AUTOLOG = true;
            }
            if (exception instanceof IBaseException && (iBaseExceptionRootcause = ((IBaseException)((Object)exception)).getRootCause()) != null && !(iBaseExceptionRootcause instanceof IBaseException)) {
                Logger rootcauseLogger = Logger.getLogger("AutoLog.created." + iBaseExceptionRootcause.getClass().getName());
                rootcauseLogger.log(Level.DEBUG, iBaseExceptionRootcause.getMessage());
                rootcauseLogger.log(Level.FINE, BaseException.getStackTrace(iBaseExceptionRootcause));
            }
            Logger logger = Logger.getLogger("AutoLog.created." + exception.getClass().getName());
            if (exception instanceof IBaseException) {
                logger.log(Level.DEBUG, ((IBaseException)((Object)exception)).getBabelMessage());
            } else {
                logger.log(Level.DEBUG, exception.getMessage());
            }
            logger.log(Level.FINE, BaseException.getStackTrace(exception));
        }
        catch (Exception e) {
            Logger logger = Logger.getLogger(exception.getClass().getName());
            logger.error("The auto logging of the BaseException " + exception.getClass().getName() + " failed.", e);
        }
    }

    public Level getSeverity() {
        return this.severity;
    }

    public void setSeverity(Level level) {
        if (level != null && (level.equals(Level.INFO) || level.equals(Level.WARNING) || level.equals(Level.ERROR) || level.equals(Level.FATAL))) {
            this.severity = level;
        }
    }

    public void setWrapBeforeVisualisation(boolean wrapBeforeVisualisation) {
        this.wrapBeforeVisualisation = wrapBeforeVisualisation;
    }

    public boolean getWrapBeforeVisualisation() {
        return this.wrapBeforeVisualisation;
    }

    public String getErrorCode() {
        return this.message.getMessageId();
    }

    public void setRootCause(Throwable rootCause) {
        this.rootCause = rootCause;
    }

    public Throwable getRootCause() {
        return this.rootCause;
    }

    public void setBabelMessage(BabelMessage bm) {
        if (bm != null) {
            this.message = bm;
        } else {
            this.setMessage(null);
        }
    }

    public BabelMessage getBabelMessage() {
        return this.message;
    }

    public void setAssistanceMessage(Message am) {
        this.assistance = am;
    }

    public Message getAssistanceMessage() {
        return this.assistance;
    }

    public void setMessage(String text) {
        this.message = BabelMessage.createFromString(text);
        this.message.setMessageId(this.getClass().getName());
    }

    public String getMessage() {
        return this.getMessage(null);
    }

    public String getMessage(Locale loc) {
        return this.message.toString(loc);
    }

    public void finallyLocalize(Locale loc) {
        this.message.finallyLocalize(loc);
        if (this.getRootCause() instanceof IBaseException) {
            ((IBaseException)((Object)this.getRootCause())).finallyLocalize(loc);
        }
    }

    private static String getStackTrace(Throwable e) {
        if (e == null) {
            return null;
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        return sw.toString();
    }
}

