/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.util.misc.api;

import com.sap.aii.util.misc.api.ComparatorSortObject;
import com.sap.aii.util.misc.api.SortObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;

public class ArrayUtil {
    public static ArrayList createArrayList(Object[] array) {
        if (array == null) {
            return null;
        }
        ArrayList<Object> myArrayList = new ArrayList<Object>(array.length);
        int i = 0;
        while (i < array.length) {
            myArrayList.add(array[i]);
            ++i;
        }
        return myArrayList;
    }

    public static int[] sort(Comparable[] objects, boolean ascending) {
        if (objects == null || objects.length == 0) {
            return new int[0];
        }
        int size = objects.length;
        Object[] sorts = new SortObject[size];
        int i = 0;
        while (i < sorts.length) {
            sorts[i] = new SortObject(objects[i], i);
            ++i;
        }
        Arrays.sort(sorts);
        int[] myIndexMap = new int[size];
        if (ascending) {
            int i2 = 0;
            while (i2 < size) {
                myIndexMap[i2] = ((SortObject)sorts[i2]).getIndex();
                ++i2;
            }
        } else {
            int i3 = 0;
            while (i3 < size) {
                myIndexMap[size - 1 - i3] = ((SortObject)sorts[i3]).getIndex();
                ++i3;
            }
        }
        return myIndexMap;
    }

    public static int[] sort(Object[] objects, Comparator comp, boolean ascending) {
        if (objects == null || objects.length == 0) {
            return new int[0];
        }
        int size = objects.length;
        Object[] sorts = new ComparatorSortObject[size];
        int i = 0;
        while (i < sorts.length) {
            sorts[i] = new ComparatorSortObject(objects[i], i, comp);
            ++i;
        }
        Arrays.sort(sorts);
        int[] myIndexMap = new int[size];
        if (ascending) {
            int i2 = 0;
            while (i2 < size) {
                myIndexMap[i2] = ((ComparatorSortObject)sorts[i2]).getIndex();
                ++i2;
            }
        } else {
            int i3 = 0;
            while (i3 < size) {
                myIndexMap[size - 1 - i3] = ((ComparatorSortObject)sorts[i3]).getIndex();
                ++i3;
            }
        }
        return myIndexMap;
    }
}

