/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.util.log.servlet;

import com.sap.aii.util.log.api.Level;
import com.sap.aii.util.log.api.Logger;
import com.sap.aii.util.log.impl.AIILogFactoryImpl;
import com.sap.aii.util.log.impl.Handler;
import com.sap.aii.util.log.impl.PropertiesConfigurator;
import com.sap.aii.util.log.servlet.Tool;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ControlLog
extends HttpServlet {
    private static final String CONTENT_TYPE = "text/html";
    private static final String RESET = "Reset Configuration";
    private static final String SET_LEVEL = "Set Level";
    private static AIILogFactoryImpl logFactory = AIILogFactoryImpl.getInstance();
    private String status = "ready";
    private String logClass = "";
    private String logLevel = "ALL";

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
    }

    private void writeHeader(PrintWriter out) {
        String thisServlet = "./ControlLog";
        Tool.writeHTMLHeader(out, "Logging Control");
        out.println("<div style=\"background-color:#e0e0e0\">");
        out.println("<b>Status:</b> " + this.status);
        out.println("</div>");
        Tool.checkLoggingImpl(out);
        out.println("<hr>");
        out.println("Links: <a href=\"./ShowMemLog\">Show MemLog</a>");
        out.println("<hr>");
        out.println("<form action=\"" + thisServlet + "\" method=post>");
        out.println("<input type=submit name=action value=\"Reset Configuration\">");
        out.println("</form>");
        out.println("<hr>");
        out.println("<form action=\"" + thisServlet + "\" method=post>");
        out.println("<table>");
        out.println("<tr><td align=right>Log Category:</td><td>");
        Tool.writeLoggerSelect(out, "class", this.logClass);
        out.println("</td></tr>");
        out.println("<tr><td align=right>OutputLevel:</td> <td>");
        Tool.writeLevelSelect(out, "level", this.logLevel);
        out.println("</td></tr>");
        out.println("</table>");
        out.println("<input type=hidden name=action value=\"Set Level\">");
        out.println("<input type=submit value=\"Set Level\">");
        out.println("</form>");
        out.println("<hr>");
    }

    private void writeFooter(PrintWriter out) {
        out.println("<table border><colgroup><col width=\"33%\"/><col width=\"33%\"/><col width=\"33%\"/></colgroup>");
        out.println("<tr><th>Logger</th><th>Level</th><th>Handler</th></tr>");
        out.println("<tr><td valign=top align=left>");
        out.println("<pre>");
        Logger[] loggers = logFactory.getAllLoggers();
        Arrays.sort(loggers, new Logger.NameComparator());
        int i = 0;
        while (i < loggers.length) {
            String name = loggers[i].getName();
            out.print("\"" + name + "\"");
            Level level = loggers[i].getLevel();
            if (level != null) {
                out.print("(" + level.getName() + ")");
            }
            out.println();
            ++i;
        }
        out.println("</pre>");
        out.println("</td><td valign=top align=left>");
        out.println("<pre>");
        Object[] levels = Level.getAllLevels();
        Arrays.sort(levels);
        int i2 = 0;
        while (i2 < levels.length) {
            String name = ((Level)levels[i2]).getName();
            out.println("\"" + name + "\"=(" + Level.getLevel(name).getPriority() + ")");
            ++i2;
        }
        out.println("</pre>");
        out.println("</td><td valign=top align=left>");
        out.println("<pre>");
        Handler[] handlers = Handler.getAllHandlers();
        Arrays.sort(handlers, new Handler.NameComparator());
        int i3 = 0;
        while (i3 < handlers.length) {
            out.print("\"" + handlers[i3].getName() + "\"");
            Level level = handlers[i3].getLevel();
            if (level != null) {
                out.println("(" + level.getName() + ")");
            } else {
                out.println();
            }
            ++i3;
        }
        out.println("</pre>");
        out.println("</td></tr>");
        out.println("</table>");
        out.println("<hr>");
        Tool.writeHTMLFooter(out);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType(CONTENT_TYPE);
        PrintWriter out = response.getWriter();
        this.writeHeader(out);
        this.writeFooter(out);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType(CONTENT_TYPE);
        PrintWriter out = response.getWriter();
        String action = Tool.getStringParam(request, "action");
        if (action.equals(RESET)) {
            PropertiesConfigurator.resetAll();
            this.status = "read Logger configuration";
        } else if (action.equals(SET_LEVEL)) {
            this.logClass = Tool.getStringParam(request, "class");
            this.logLevel = Tool.getStringParam(request, "level");
            Level level = Level.getLevel(this.logLevel);
            if (level == null) {
                level = Level.DEFAULT;
            }
            Logger logger = logFactory.getLogger(this.logClass);
            logger.setLevel(level);
            this.status = "Logger " + logger.getName() + ": set Level to " + logger.getLevel();
        }
        this.writeHeader(out);
        this.writeFooter(out);
    }

    public void destroy() {
    }
}

