/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.util.log.sap;

import com.sap.aii.util.log.api.Level;
import com.sap.aii.util.log.api.LogUtil;
import com.sap.aii.util.log.api.Logger;
import com.sap.tc.logging.Location;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;

class SAPLoggerImpl
extends Logger {
    private static Map categoryMap = new Hashtable();
    private Level level;
    private Location location;
    private boolean useParentHandlers = true;
    private static final int PRIO_ALL = Level.ALL.getPriority();
    private static final int PRIO_DEBUG = Level.DEBUG.getPriority();
    private static final int PRIO_PATH = Level.PATH.getPriority();
    private static final int PRIO_INFO = Level.INFO.getPriority();
    private static final int PRIO_WARNING = Level.WARNING.getPriority();
    private static final int PRIO_ERROR = Level.ERROR.getPriority();
    private static final int PRIO_FATAL = Level.FATAL.getPriority();
    private static final int PRIO_OFF = Level.OFF.getPriority();

    SAPLoggerImpl(String name, Location location) {
        this.location = location;
        categoryMap.put(name, this);
    }

    SAPLoggerImpl(String name) {
        this(name, Location.getLocation((String)name));
    }

    public static Logger getLogger(String name) {
        Logger result = categoryMap.containsKey(name) ? (Logger)categoryMap.get(name) : new SAPLoggerImpl(name);
        return result;
    }

    private static int getSeverity(Level level) {
        int prio = level.getPriority();
        if (prio <= PRIO_ALL) {
            return 0;
        }
        if (prio <= PRIO_DEBUG) {
            return 100;
        }
        if (prio <= PRIO_PATH) {
            return 200;
        }
        if (prio <= PRIO_INFO) {
            return 300;
        }
        if (prio <= PRIO_WARNING) {
            return 400;
        }
        if (prio <= PRIO_ERROR) {
            return 500;
        }
        if (prio <= PRIO_FATAL) {
            return 600;
        }
        return 701;
    }

    public void log(Level level, String message, Throwable t) {
        if (t != null) {
            message = message + "\n" + LogUtil.formatThrowable(t);
        }
        this.location.logT(SAPLoggerImpl.getSeverity(level), message);
    }

    public void setLevel(Level level) {
        this.level = level;
        if (level == null) {
            this.location.setEffectiveSeverity();
        }
    }

    public Level getLevel() {
        return this.level;
    }

    public Level getActiveLevel() {
        return Level.getLevel(this.location.getEffectiveSeverity());
    }

    public String toString() {
        return this.getName() + '(' + this.level + ')';
    }

    public String getName() {
        return this.location.getName();
    }

    public void setUseParentHandlers(boolean flag) {
        this.useParentHandlers = flag;
    }

    public Enumeration listHandlers() {
        return new Enumeration(){

            public boolean hasMoreElements() {
                return false;
            }

            public Object nextElement() {
                return null;
            }
        };
    }
}

