/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.util.log.sap;

import com.sap.aii.util.log.api.Level;
import com.sap.aii.util.log.api.LogFactory;
import com.sap.aii.util.log.api.Logger;
import com.sap.aii.util.log.api.SimpleLog;
import com.sap.aii.util.log.impl.AIILogFactoryImpl;
import com.sap.aii.util.log.impl.LoggerImpl;
import com.sap.aii.util.log.sap.SAPLogFactoryImpl;
import com.sap.aii.util.log.sap.SAPLoggerImpl;
import java.util.Enumeration;

public class DualLogFactoryImpl
implements LogFactory {
    public static final String implName = "Dual SAP/AII Logging";
    public static final String implVersion = "1.0";
    private static AIILogFactoryImpl aiiFactory;
    private static SAPLogFactoryImpl sapFactory;

    public String getImplementationName() {
        return implName;
    }

    public String getImplementationVersion() {
        return implVersion;
    }

    public void setActive(boolean active) {
    }

    public Logger getRootLogger() {
        return new DualLoggerImpl("");
    }

    public Logger getLogger(String name) {
        return DualLoggerImpl.getLogger(name);
    }

    public Logger[] getAllLoggers() {
        return aiiFactory.getAllLoggers();
    }

    public void initConfiguration() {
    }

    public void clearConfiguration() {
    }

    static {
        try {
            aiiFactory = new AIILogFactoryImpl();
            sapFactory = new SAPLogFactoryImpl();
        }
        catch (ClassNotFoundException e) {
            SimpleLog.error("could not init SAPLogging", e);
        }
    }

    private static class DualLoggerImpl
    extends Logger {
        private static boolean active = true;
        private Level level;
        private SAPLoggerImpl sapLogger;
        private LoggerImpl aiiLogger;

        private DualLoggerImpl(String name) {
            if (name.length() == 0 || name.equals("ROOT")) {
                this.aiiLogger = (LoggerImpl)aiiFactory.getRootLogger();
                this.sapLogger = (SAPLoggerImpl)sapFactory.getRootLogger();
            } else {
                this.aiiLogger = (LoggerImpl)aiiFactory.getLogger(name);
                this.sapLogger = (SAPLoggerImpl)sapFactory.getLogger(name);
            }
        }

        public static Logger getLogger(String name) {
            return new DualLoggerImpl(name);
        }

        public void log(Level level, String message, Throwable t) {
            this.aiiLogger.log(level, message, t);
            this.sapLogger.log(level, message, t);
        }

        public void setLevel(Level level) {
            this.aiiLogger.setLevel(level);
            this.sapLogger.setLevel(level);
        }

        public Level getLevel() {
            return this.sapLogger.getLevel();
        }

        public Level getActiveLevel() {
            return this.sapLogger.getActiveLevel();
        }

        public String toString() {
            return this.getName() + '(' + this.level + ')';
        }

        public String getName() {
            return this.sapLogger.getName();
        }

        public void setUseParentHandlers(boolean flag) {
            this.aiiLogger.setUseParentHandlers(flag);
        }

        public Enumeration listHandlers() {
            return this.aiiLogger.listHandlers();
        }
    }
}

