/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.util.log.impl;

import com.sap.aii.util.log.impl.ConsoleHandler;
import com.sap.aii.util.log.impl.Handler;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Vector;

public class SocketListener {
    private ServerSocket serverSocket;
    private int port;
    private Vector handlers = new Vector();

    public SocketListener(int port) throws IOException {
        this.serverSocket = new ServerSocket(port);
        this.port = port;
    }

    public void addHandler(Handler handler) {
        this.handlers.addElement(handler);
    }

    private void out(String s) {
        int i = 0;
        while (i < this.handlers.size()) {
            Handler w = (Handler)this.handlers.get(i);
            w.publish(s);
            ++i;
        }
    }

    public void start() {
        while (true) {
            try {
                Socket socket = this.serverSocket.accept();
                this.out("[connection from " + socket.getInetAddress() + "]");
                BufferedReader in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                String s = in.readLine();
                while (s != null) {
                    this.out(s);
                    s = in.readLine();
                }
                in.close();
                socket.close();
                this.out("[connection closed]\n");
            }
            catch (IOException iOException) {
                continue;
            }
            break;
        }
    }

    public static void main(String[] args) throws Exception {
        int port = 4711;
        if (args.length == 1) {
            port = Integer.parseInt(args[0]);
        }
        System.out.println("\n--- SocketListener ---\n");
        System.out.println("listening to port " + port + "\n");
        SocketListener listener = new SocketListener(port);
        listener.addHandler(new ConsoleHandler());
        listener.start();
    }
}

