/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.util.log.impl;

import com.sap.aii.util.log.api.Level;
import com.sap.aii.util.log.api.LogUtil;
import com.sap.aii.util.log.impl.Handler;
import com.sap.aii.util.log.impl.LogRecord;
import com.sap.tc.logging.Location;
import java.util.HashMap;
import java.util.Map;

public class SAPHandler
extends Handler {
    private static final String DEFAULT_LOCATION = "default";
    private static final Location defaultLoc = Location.getLocation((String)"default");
    private static final String EOL = "\n";
    private Map locationMap = new HashMap();
    private static final int PRIO_ALL = Level.ALL.getPriority();
    private static final int PRIO_DEBUG = Level.DEBUG.getPriority();
    private static final int PRIO_PATH = Level.PATH.getPriority();
    private static final int PRIO_INFO = Level.INFO.getPriority();
    private static final int PRIO_WARNING = Level.WARNING.getPriority();
    private static final int PRIO_ERROR = Level.ERROR.getPriority();
    private static final int PRIO_FATAL = Level.FATAL.getPriority();
    private static final int PRIO_OFF = Level.OFF.getPriority();

    public SAPHandler(String name) {
        super(name);
    }

    public SAPHandler() {
        this(null);
    }

    private static int getSeverity(Level level) {
        int prio = level.getPriority();
        if (prio <= PRIO_ALL) {
            return 0;
        }
        if (prio <= PRIO_DEBUG) {
            return 100;
        }
        if (prio <= PRIO_PATH) {
            return 200;
        }
        if (prio <= PRIO_INFO) {
            return 300;
        }
        if (prio <= PRIO_WARNING) {
            return 400;
        }
        if (prio <= PRIO_ERROR) {
            return 500;
        }
        if (prio <= PRIO_FATAL) {
            return 600;
        }
        return 701;
    }

    public void publish(LogRecord rec) {
        String name = rec.getLoggerName();
        Location loc = (Location)this.locationMap.get(name);
        if (loc == null) {
            loc = Location.getLocation((String)name);
            this.locationMap.put(name, loc);
        }
        String message = rec.getMessage();
        if (rec.getThrown() != null) {
            message = message + EOL + LogUtil.formatThrowable(rec.getThrown());
        }
        loc.logT(SAPHandler.getSeverity(rec.getLevel()), message);
    }

    public void publish(String message) {
        defaultLoc.logT(300, message);
    }

    public void close() {
    }
}

