/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.util.log.impl;

import com.sap.aii.util.log.api.Level;
import com.sap.aii.util.log.api.Logger;
import com.sap.aii.util.log.impl.Filter;
import com.sap.aii.util.log.impl.Handler;
import com.sap.aii.util.log.impl.LogRecord;
import com.sap.aii.util.log.impl.SimpleFilter;
import java.util.Enumeration;

public class MemLogHandler
extends Handler {
    private LogRecord[] buffer;
    private int count;
    private int size;
    private int start;

    public MemLogHandler(String name, int size) {
        super(name);
        this.buffer = new LogRecord[size];
        this.count = -1;
        this.size = size;
        this.start = 0;
    }

    public MemLogHandler(int size) {
        this(null, size);
    }

    public void publish(LogRecord rec) {
        if (this.getLevel() == null || rec.getLevel().getPriority() >= this.getLevel().getPriority()) {
            ++this.count;
            this.buffer[this.count % this.size] = rec;
        }
    }

    public void publish(String message) {
    }

    public void close() {
    }

    public synchronized void setSize(int size) {
        if (size != this.size) {
            this.buffer = new LogRecord[size];
            this.count = -1;
            this.size = size;
            this.start = 0;
        }
    }

    public int getSize() {
        return this.size;
    }

    public void clear() {
        this.count = -1;
    }

    public Enumeration getLogMessages(Logger logger, Level level, String thread) {
        return new MHEnum(new SimpleFilter(logger, level, thread), true);
    }

    public Enumeration getLogMessages(Filter filter) {
        return new MHEnum(filter, true);
    }

    public Enumeration getLogRecords() {
        return new MHEnum(null, false);
    }

    class MHEnum
    implements Enumeration {
        private int n;
        private Object nextOutput;
        private Filter filter;
        private boolean formatIt;

        public MHEnum(Filter filter, boolean formatIt) {
            this.filter = filter;
            this.formatIt = formatIt;
            this.n = MemLogHandler.this.count + 1;
            this.nextOutput = this.getNext();
        }

        private Object getNext() {
            LogRecord rec;
            do {
                if (this.n <= MemLogHandler.this.start || this.n <= MemLogHandler.this.count - MemLogHandler.this.size + 1) {
                    return null;
                }
                --this.n;
                rec = MemLogHandler.this.buffer[this.n % MemLogHandler.this.size];
            } while (this.filter != null && !this.filter.isLoggable(rec));
            if (this.formatIt) {
                return MemLogHandler.this.formatter.format(rec);
            }
            return rec;
        }

        public boolean hasMoreElements() {
            return this.nextOutput != null;
        }

        public Object nextElement() {
            Object output = this.nextOutput;
            this.nextOutput = this.getNext();
            return output;
        }
    }
}

