/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.util.log.impl;

import com.sap.aii.util.log.api.Level;
import com.sap.aii.util.log.api.Logger;
import com.sap.aii.util.log.api.SimpleLog;
import com.sap.aii.util.log.impl.Handler;
import com.sap.aii.util.log.impl.LogRecord;
import com.sap.aii.util.log.impl.PropertiesConfigurator;
import com.sap.aii.util.misc.api.BaseException;
import com.sap.aii.util.misc.api.BaseRuntimeException;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;

public class LoggerImpl
extends Logger {
    private static final int MAX_MESSAGE_LENGTH = 8000;
    static Map categoryMap = new Hashtable();
    static final String ROOT_NAME;
    static final LoggerImpl ROOT;
    static boolean active;
    private String name;
    private Level level;
    private Level activeLevel;
    private int depth;
    private LoggerImpl parent;
    private List children;
    private int count;
    private boolean useParentHandlers = true;
    private Vector handlers = new Vector();
    private CounterMap counterMap = null;

    protected LoggerImpl(String name, LoggerImpl parent) {
        this.name = name;
        this.parent = parent;
        this.level = null;
        this.children = new Vector();
        if (parent != null) {
            this.activeLevel = parent.getActiveLevel();
            parent.children.add(this);
        } else {
            this.activeLevel = Level.DEFAULT;
        }
        this.depth = parent == null ? 0 : parent.depth + 1;
        categoryMap.put(name, this);
    }

    static LoggerImpl getInstance(String name) {
        LoggerImpl result;
        if (categoryMap.containsKey(name)) {
            result = (LoggerImpl)categoryMap.get(name);
        } else {
            int pos = name.lastIndexOf(46);
            String parentName = pos < 0 ? ROOT_NAME : name.substring(0, pos);
            LoggerImpl parent = LoggerImpl.getInstance(parentName);
            result = new LoggerImpl(name, parent);
        }
        return result;
    }

    public void log(BaseException exception) {
        this.log(exception.getSeverity(), exception.getMessage(), exception);
    }

    public void log(BaseRuntimeException exception) {
        this.log(exception.getSeverity(), exception.getMessage(), exception);
    }

    public void log(Throwable throwable) {
        this.log(Level.ERROR, throwable.getMessage(), throwable);
    }

    public void log(Level level, String message) {
        this.log(level, message, null);
    }

    public void log(Level level, String message, Throwable t) {
        if (level == null) {
            level = Level.DEFAULT;
        }
        try {
            if (active && level.getPriority() >= this.getActiveLevel().getPriority()) {
                if (message != null && message.length() > 8000) {
                    message = message.substring(0, 8000) + "...";
                }
                LogRecord rec = new LogRecord(this.name, level, message);
                if (t != null) {
                    rec.setThrown(t);
                }
                this.publish(rec);
            }
        }
        catch (Exception e) {
            SimpleLog.error("in log", e);
        }
    }

    public void log(String message) {
        this.log(Level.DEFAULT, message);
    }

    public void fatal(String message, Throwable t) {
        this.log(Level.FATAL, message, t);
    }

    public void error(String message, Throwable t) {
        this.log(Level.ERROR, message, t);
    }

    public void warning(String message, Throwable t) {
        this.log(Level.WARNING, message, t);
    }

    public void fatal(String message) {
        this.log(Level.FATAL, message, null);
    }

    public void error(String message) {
        this.log(Level.ERROR, message, null);
    }

    public void warning(String message) {
        this.log(Level.WARNING, message, null);
    }

    public void info(String message) {
        this.log(Level.INFO, message, null);
    }

    public void path(String message) {
        this.log(Level.PATH, message, null);
    }

    public void entering(String method) {
        this.log(Level.PATH, "entering: " + method, null);
    }

    public void exiting(String method) {
        this.log(Level.PATH, "exiting: " + method, null);
    }

    public void debug(String message) {
        this.log(Level.DEBUG, message, null);
    }

    public void fine(String message) {
        this.log(Level.FINE, message, null);
    }

    public void finer(String message) {
        this.log(Level.FINER, message, null);
    }

    public void finest(String message) {
        this.log(Level.FINEST, message, null);
    }

    public void setLevel(Level level) {
        if (level != this.level) {
            if (level != null && level.getPriority() > this.getActiveLevel().getPriority()) {
                SimpleLog.info("changing output level of \"" + this.getName() + "\" from " + this.getActiveLevel() + " to " + level);
            }
            this.level = level;
            if (level == null) {
                level = this.parent != null ? this.parent.getActiveLevel() : Level.DEFAULT;
            }
            this.setActiveLevel(level);
        }
    }

    private void setActiveLevel(Level level) {
        this.activeLevel = level;
        List list = this.children;
        synchronized (list) {
            Iterator i = this.children.iterator();
            while (i.hasNext()) {
                LoggerImpl child = (LoggerImpl)i.next();
                if (child.level != null) continue;
                child.setActiveLevel(level);
            }
        }
    }

    public Level getLevel() {
        return this.level;
    }

    public Level getActiveLevel() {
        if (!active) {
            return Level.OFF;
        }
        if (this.level != null) {
            return this.level;
        }
        if (this.activeLevel != null) {
            return this.activeLevel;
        }
        if (this.parent != null) {
            return this.parent.getActiveLevel();
        }
        return Level.ALL;
    }

    public boolean isLoggable(Level level) {
        return this.getActiveLevel().compareTo(level) <= 0;
    }

    public String toString() {
        return this.name + '(' + this.level + ')';
    }

    private void publish(LogRecord rec) {
        int i = 0;
        while (i < this.handlers.size()) {
            ((Handler)this.handlers.get(i)).publish(rec);
            ++i;
        }
        if (this.parent != null && this.useParentHandlers) {
            this.parent.publish(rec);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getShortName() {
        int pos = this.name.lastIndexOf(46);
        if (pos < 0) {
            return this.name;
        }
        return this.name.substring(pos + 1);
    }

    public void setUseParentHandlers(boolean flag) {
        this.useParentHandlers = flag;
    }

    public void addHandler(Handler handler) {
        this.handlers.addElement(handler);
    }

    public void removeAllHandlers() {
        this.handlers.removeAllElements();
        SimpleLog.debug("removing all Handlers from " + this.getName());
    }

    public void removeHandler(Handler handler) {
        this.handlers.remove(handler);
    }

    public void removeHandler(String name) {
        this.handlers.remove(Handler.getHandler(name));
    }

    public Enumeration listHandlers() {
        return this.handlers.elements();
    }

    public boolean contains(Logger p) {
        if (p instanceof LoggerImpl) {
            while (p != null) {
                if (p == this) {
                    return true;
                }
                p = ((LoggerImpl)p).parent;
            }
            return false;
        }
        return super.contains(p);
    }

    public int getCount() {
        return this.counterMap != null ? this.counterMap.getTotalCount() : this.count;
    }

    public CounterMap getCounters() {
        return this.counterMap;
    }

    public LoggerImpl[] getChildren() {
        return this.children.toArray(new LoggerImpl[0]);
    }

    public LoggerImpl getParent() {
        return this.parent;
    }

    static {
        active = true;
        ROOT_NAME = "ROOT";
        ROOT = new LoggerImpl(ROOT_NAME, null);
        PropertiesConfigurator.init();
    }

    public static class NameComparator
    implements Comparator {
        public int compare(Object o1, Object o2) throws ClassCastException {
            LoggerImpl log1 = (LoggerImpl)o1;
            LoggerImpl log2 = (LoggerImpl)o2;
            int diff = log1.depth - log2.depth;
            if (log1.depth == 0 ^ log2.depth == 0) {
                return diff;
            }
            return log1.getName().compareTo(log2.getName());
        }

        public boolean equals(Object o1, Object o2) throws ClassCastException {
            return ((Logger)o1).getName().equals(((Logger)o2).getName());
        }
    }

    public static class CounterMap {
        private int total = 0;
        private Map counters = new TreeMap();

        public void inc(Object key) {
            Counter counter = (Counter)this.counters.get(key);
            if (counter == null) {
                counter = new Counter();
                this.counters.put(key, counter);
            }
            ++counter.count;
            ++this.total;
        }

        public int getCount(Object key) {
            Counter counter = (Counter)this.counters.get(key);
            return counter == null ? 0 : counter.count;
        }

        public int getTotalCount() {
            return this.total;
        }

        public Iterator iterator() {
            return this.counters.keySet().iterator();
        }

        private static class Counter {
            public int count = 0;

            private Counter() {
            }
        }
    }
}

