/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.util.log.impl;

import com.sap.aii.util.log.api.LogUtil;
import com.sap.aii.util.log.impl.Formatter;
import com.sap.aii.util.log.impl.LogRecord;
import java.text.DateFormat;

public class DefaultFormatter
extends Formatter {
    private static final DateFormat df = DateFormat.getTimeInstance(2);

    public String format(LogRecord rec) {
        StringBuffer sb = new StringBuffer();
        sb.append("#");
        sb.append(rec.getSequenceNumber());
        sb.append(" ");
        sb.append(df.format(rec.getDate()));
        sb.append(" [");
        sb.append(rec.getThreadName());
        sb.append("] ");
        sb.append(rec.getLevel().getName());
        sb.append(" ");
        sb.append(rec.getLoggerName());
        sb.append(": ");
        sb.append(rec.getMessage());
        Throwable t = rec.getThrown();
        if (t != null) {
            sb.append("\n").append(LogUtil.formatThrowable(t));
        }
        return sb.toString();
    }
}

