/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.util.log.api;

import com.sap.aii.util.log.api.LogFactory;
import com.sap.aii.util.log.api.Logger;
import com.sap.aii.util.log.api.SimpleLog;
import com.sap.aii.util.log.impl.AIILogFactoryImpl;

public class LogManager {
    private static LogFactory factory = null;
    private static final String PROPERTY_LOG_FACTORY = "com.sap.aii.util.log.LogFactory";
    private static final String DEFAULT_LOG_FACTORY = "com.sap.aii.util.log.impl.AIILogFactoryImpl";

    public static LogFactory getLogFactory() {
        return factory;
    }

    public static Logger getClassLogger(Object obj) {
        String className = obj.getClass().getName();
        return LogManager.getLogFactory().getLogger(className);
    }

    public static Logger getLogger(String name) {
        return LogManager.getLogFactory().getLogger(name);
    }

    public static Logger getRootLogger() {
        return LogManager.getLogFactory().getRootLogger();
    }

    public static Logger[] getAllLoggers() {
        return LogManager.getLogFactory().getAllLoggers();
    }

    public void clearConfiguration() {
        LogManager.getLogFactory().clearConfiguration();
    }

    public static void resetConfiguration() {
        LogManager.getLogFactory().clearConfiguration();
        LogManager.getLogFactory().initConfiguration();
    }

    public static void setActive(boolean active) {
        LogManager.getLogFactory().setActive(active);
    }

    static {
        String factoryName = null;
        try {
            factoryName = System.getProperty(PROPERTY_LOG_FACTORY);
        }
        catch (Exception ex) {
            SimpleLog.info("could not read property \"com.sap.aii.util.log.LogFactory\": " + ex.getMessage());
        }
        if (factoryName != null) {
            try {
                Class<?> factoryClass = Class.forName(factoryName);
                factory = (LogFactory)factoryClass.newInstance();
            }
            catch (ClassNotFoundException e) {
                SimpleLog.error("could not get LogFactory \"" + factoryName + "\" (" + e.getMessage() + ")");
            }
            catch (Exception e) {
                SimpleLog.error("could not get LogFactory \"" + factoryName + "\"", e);
            }
        }
        if (factory == null) {
            factory = new AIILogFactoryImpl();
            SimpleLog.info("using default logging implementation");
        }
        SimpleLog.info("using logging implementation \"" + factory.getImplementationName() + "\"");
    }
}

